/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.websocket;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;
import org.mydotey.artemis.client.common.AddressContext;
import org.mydotey.artemis.client.common.AddressManager;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.websocket.WebSocketSessionCallback;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.caravan.util.ratelimiter.RateLimiter;
import org.mydotey.caravan.util.ratelimiter.RateLimiterConfig;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueConfig;
import org.mydotey.scf.filter.RangeValueFilter;
import org.mydotey.util.TimeSequenceCircularBufferConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;

public abstract class WebSocketSessionContext {
    private static final Logger _logger = LoggerFactory.getLogger(WebSocketSessionContext.class);
    private final Property<String, Long> _ttl;
    private final Property<String, Long> _connectTimeout;
    private final Property<String, Long> pingTimeout;
    private final AtomicReference<WebSocketSession> _session = new AtomicReference();
    private volatile long _lastUpdatedTime = System.currentTimeMillis();
    private final AtomicBoolean _isConnecting = new AtomicBoolean(false);
    private final WebSocketClient _wsClient;
    private final WebSocketHandler _handler;
    private final DynamicScheduledThread _healthChecker;
    private final AddressManager _addressManager;
    private final AtomicReference<AddressContext> _addressContext = new AtomicReference();
    private final AtomicBoolean _isChecking = new AtomicBoolean(false);
    private final Object receivePong = new Object();
    private final RateLimiter rateLimiter;
    private final Property<String, Integer> defaultMaxTextMessageBufferSize;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public WebSocketSessionContext(ArtemisClientConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config");
        this._ttl = config.properties().getLongProperty((Object)config.key("websocket-session.ttl"), Long.valueOf(300000L), (Function)new RangeValueFilter((Comparable)Long.valueOf(300000L), (Comparable)Long.valueOf(1800000L)));
        this._connectTimeout = config.properties().getLongProperty((Object)config.key("websocket-session.connect-timeout"), Long.valueOf(5000L), (Function)new RangeValueFilter((Comparable)Long.valueOf(1000L), (Comparable)Long.valueOf(30000L)));
        this.pingTimeout = config.properties().getLongProperty((Object)config.key("websocket-session.ping-timeout"), Long.valueOf(1000L), (Function)new RangeValueFilter((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(10000L)));
        this.defaultMaxTextMessageBufferSize = config.properties().getIntProperty((Object)config.key("websocket-session.text-message.buffer-size"), Integer.valueOf(8), (Function)new RangeValueFilter((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(32)));
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        container.setDefaultMaxTextMessageBufferSize((Integer)this.defaultMaxTextMessageBufferSize.getValue() * 1024);
        this._wsClient = new StandardWebSocketClient(container);
        this._addressManager = config.addressManager();
        this._addressContext.set(this._addressManager.getContext());
        this._handler = new WebSocketHandler(){

            public void afterConnectionEstablished(WebSocketSession session) throws Exception {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
                if (message instanceof TextMessage) {
                    WebSocketSessionContext.this.handleMessage(session, message);
                } else if (message instanceof PongMessage) {
                    Object object = WebSocketSessionContext.this.receivePong;
                    synchronized (object) {
                        WebSocketSessionContext.this.receivePong.notifyAll();
                    }
                }
            }

            public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
                WebSocketSessionContext.this.markdown();
                _logger.error("WebSocketSession transport error", exception);
            }

            public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
                _logger.info("WebSocketSession closed: " + closeStatus);
                WebSocketSessionContext.this.checkHealth();
            }

            public boolean supportsPartialMessages() {
                return false;
            }
        };
        this.rateLimiter = config.getRateLimiterManager().getRateLimiter(config.key("websocket-session.reconnect-times"), new RateLimiterConfig(true, new RangeValueConfig((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(3L), (Comparable)Long.valueOf(60L)), ((TimeSequenceCircularBufferConfig.Builder)((TimeSequenceCircularBufferConfig.Builder)new TimeSequenceCircularBufferConfig.Builder().setTimeWindow(20000L)).setBucketTtl(2000L)).build()));
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(config.properties(), new RangeValueConfig((Comparable)Integer.valueOf(20), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(200)), new RangeValueConfig((Comparable)Integer.valueOf(1000), (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(600000)));
        this._healthChecker = new DynamicScheduledThread(config.key("websocket-session.health-check"), new Runnable(){

            @Override
            public void run() {
                WebSocketSessionContext.this.checkHealth();
            }
        }, dynamicScheduledThreadConfig);
        this._healthChecker.setDaemon(true);
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this._healthChecker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() {
        if (this._isConnecting.compareAndSet(false, true)) {
            try {
                if (this.rateLimiter.isRateLimited("connect")) {
                    _logger.error("WebSocketSessionContext reconnect times exceed expected value for a period time");
                    return;
                }
                AddressContext context = this._addressManager.getContext();
                if (!context.isAavailable()) {
                    return;
                }
                ListenableFuture future = this._wsClient.doHandshake(this._handler, context.getWebSocketEndPoint(), new Object[0]);
                future.addCallback((ListenableFutureCallback)new WebSocketSessionCallback(this, context));
                try {
                    WebSocketSession session = (WebSocketSession)future.get(((Long)this._connectTimeout.getValue()).longValue(), TimeUnit.MILLISECONDS);
                    WebSocketSession oldSession = this._session.getAndSet(session);
                    this._lastUpdatedTime = System.currentTimeMillis();
                    this._addressContext.set(context);
                    WebSocketSessionContext.disconnect(oldSession);
                    this.afterConnectionEstablished(session);
                    _logger.info("WebSocketSessionContext connected to: " + context.getWebSocketEndPoint());
                }
                catch (Throwable ex) {
                    context.markUnavailable();
                    _logger.warn("get WebSocketSession failed within the time specified", ex);
                }
            }
            catch (Throwable e) {
                this._addressContext.get().markUnavailable();
                _logger.warn("connect to websocket endpoint failed", e);
            }
            finally {
                this._isConnecting.set(false);
            }
        }
    }

    protected synchronized void reset(WebSocketSession session, AddressContext context) {
        if (!context.isAavailable()) {
            WebSocketSessionContext.disconnect(session);
            _logger.warn("WebSocketSession is not available now");
        }
    }

    public static void disconnect(WebSocketSession session) {
        try {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        catch (Throwable e) {
            _logger.error(" disconnect the WebSocketSession failed", e);
        }
    }

    protected boolean isAvailable() {
        WebSocketSession session = this._session.get();
        return session != null && session.isOpen() && this.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlive() {
        try {
            this._session.get().sendMessage((WebSocketMessage)new PingMessage());
            long start = System.currentTimeMillis();
            long timeout = (Long)this.pingTimeout.getValue();
            Object object = this.receivePong;
            synchronized (object) {
                this.receivePong.wait(timeout);
            }
            if (System.currentTimeMillis() > start + timeout) {
                _logger.info("ping WebSocketSession timeout");
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            _logger.warn("ping WebSocketSession failed", e);
            return false;
        }
    }

    protected boolean isExpired() {
        return System.currentTimeMillis() >= this._lastUpdatedTime + (Long)this._ttl.getValue();
    }

    public WebSocketSession get() {
        return this._session.get();
    }

    protected abstract void afterConnectionEstablished(WebSocketSession var1);

    protected abstract void handleMessage(WebSocketSession var1, WebSocketMessage<?> var2);

    public void checkHealth() {
        if (this._isChecking.compareAndSet(false, true)) {
            try {
                boolean available;
                boolean bl = available = this._addressContext.get().isAavailable() && !this.isExpired() && this.isAvailable();
                if (!available) {
                    this.connect();
                }
            }
            catch (Throwable e) {
                _logger.warn("WebSocketSession check health failed", e);
            }
            finally {
                this._isChecking.set(false);
            }
        }
    }

    public void markdown() {
        this._addressContext.get().markUnavailable();
        this.checkHealth();
    }

    public void shutdown() {
        this._healthChecker.shutdown();
    }
}

