/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.mydotey.artemis.client.ArtemisClientManagerConfig;
import org.mydotey.java.StringExtension;
import org.mydotey.java.io.file.FileExtension;
import org.mydotey.scf.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressContext {
    private static final Logger _logger = LoggerFactory.getLogger(AddressContext.class);
    private static final String _wsPrefix = "ws://";
    private static final Pattern _httpSchema = Pattern.compile("(^http://|^https://)", 2);
    private final long _createTime = System.currentTimeMillis();
    private final String _httpUrl;
    private final String _webSocketEndpoint;
    private final AtomicBoolean _available = new AtomicBoolean(false);
    private final Property<String, Integer> _ttl;

    public AddressContext(String clientId, ArtemisClientManagerConfig managerConfig) {
        this(clientId, managerConfig, "", "");
    }

    public AddressContext(String clientId, ArtemisClientManagerConfig managerConfig, String httpUrl, String wsEndpointSuffix) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)clientId) ? 1 : 0) != 0, (Object)"clientId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        this._ttl = managerConfig.properties().getIntProperty((Object)(clientId + ".address.context-ttl"), Integer.valueOf(3600000), v -> v >= 60000 && v <= 86400000 ? v : null);
        if (StringExtension.isBlank((String)httpUrl)) {
            this._httpUrl = "";
            this._webSocketEndpoint = "";
        } else {
            this._httpUrl = httpUrl;
            this._webSocketEndpoint = FileExtension.concatPathParts((String[])new String[]{_httpSchema.matcher(httpUrl).replaceAll(_wsPrefix), wsEndpointSuffix});
            this._available.set(true);
        }
    }

    public String getHttpUrl() {
        return this._httpUrl;
    }

    public String customHttpUrl(String path) {
        return FileExtension.concatPathParts((String[])new String[]{this.getHttpUrl(), path});
    }

    public String getWebSocketEndPoint() {
        return this._webSocketEndpoint;
    }

    public boolean isAavailable() {
        return this._available.get();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= (long)((Integer)this._ttl.getValue()).intValue() + this._createTime;
    }

    public void markUnavailable() {
        if (this._available.compareAndSet(true, false)) {
            _logger.info(this._httpUrl + " mark unavailable");
        }
    }
}

