/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.common;

import com.google.common.base.Preconditions;
import org.mydotey.artemis.client.ArtemisClientManagerConfig;
import org.mydotey.artemis.client.DiscoveryClientConfig;
import org.mydotey.artemis.client.RegistryClientConfig;
import org.mydotey.artemis.client.common.AddressManager;
import org.mydotey.caravan.util.metric.AuditMetricManager;
import org.mydotey.caravan.util.metric.EventMetricManager;
import org.mydotey.caravan.util.ratelimiter.RateLimiterManager;
import org.mydotey.caravan.util.ratelimiter.RateLimiterManagerConfig;
import org.mydotey.java.StringExtension;
import org.mydotey.scf.facade.StringProperties;

public class ArtemisClientConfig {
    private final String _clientId;
    private final ArtemisClientManagerConfig _managerConfig;
    private final AddressManager _addressManager;
    private final RateLimiterManager _rateLimiterManager;

    public ArtemisClientConfig(String clientId, ArtemisClientManagerConfig managerConfig, AddressManager addressManager) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)clientId) ? 1 : 0) != 0, (Object)"clientId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        Preconditions.checkArgument((addressManager != null ? 1 : 0) != 0, (Object)"addressManager");
        this._clientId = clientId;
        this._managerConfig = managerConfig;
        this._addressManager = addressManager;
        this._rateLimiterManager = new RateLimiterManager(clientId, new RateLimiterManagerConfig(managerConfig.properties()));
    }

    public String key(String suffix) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)suffix) ? 1 : 0) != 0, (Object)"suffix");
        return this._clientId + "." + suffix;
    }

    public StringProperties properties() {
        return this._managerConfig.properties();
    }

    public AddressManager addressManager() {
        return this._addressManager;
    }

    public EventMetricManager eventMetricManager() {
        return this._managerConfig.eventMetricManager();
    }

    public AuditMetricManager valueMetricManager() {
        return this._managerConfig.valueMetricManager();
    }

    public RegistryClientConfig registryClientConfig() {
        return this._managerConfig.registryClientConfig();
    }

    public DiscoveryClientConfig discoveryClientConfig() {
        return this._managerConfig.discoveryClientConfig();
    }

    public RateLimiterManager getRateLimiterManager() {
        return this._rateLimiterManager;
    }
}

