/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.common;

import java.util.Collection;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.Service;
import org.mydotey.java.StringExtension;
import org.springframework.util.CollectionUtils;

public class Conditions {
    public static boolean verifyInstance(Instance instance) {
        return instance != null && !StringExtension.isBlank((String)instance.getInstanceId()) && !StringExtension.isBlank((String)instance.getServiceId()) && !StringExtension.isBlank((String)instance.getUrl());
    }

    public static boolean verifyInstances(Instance[] instances) {
        if (instances == null || instances.length == 0) {
            return false;
        }
        for (Instance instance : instances) {
            if (Conditions.verifyInstance(instance)) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyInstances(Collection<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return false;
        }
        for (Instance instance : instances) {
            if (Conditions.verifyInstance(instance)) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyService(Service service) {
        return service != null && !StringExtension.isBlank((String)service.getServiceId());
    }

    public static boolean verifyServices(Collection<Service> services) {
        if (CollectionUtils.isEmpty(services)) {
            return false;
        }
        for (Service service : services) {
            if (Conditions.verifyService(service)) continue;
            return false;
        }
        return true;
    }
}

