/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.mydotey.artemis.ResponseStatus;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.common.ArtemisHttpClient;
import org.mydotey.artemis.config.DeploymentConfig;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.artemis.discovery.LookupRequest;
import org.mydotey.artemis.discovery.LookupResponse;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.springframework.util.CollectionUtils;

public class ArtemisDiscoveryHttpClient
extends ArtemisHttpClient {
    public ArtemisDiscoveryHttpClient(ArtemisClientConfig config) {
        super(config, config.key("discovery"));
    }

    public Service getService(DiscoveryConfig discoveryConfig) {
        Preconditions.checkArgument((discoveryConfig != null ? 1 : 0) != 0, (Object)"discoveryConfig");
        List<Service> services = this.getServices(Lists.newArrayList((Object[])new DiscoveryConfig[]{discoveryConfig}));
        if (services.size() > 0) {
            return services.get(0);
        }
        throw new RuntimeException("not found any service by discoveryConfig:" + discoveryConfig);
    }

    public List<Service> getServices(List<DiscoveryConfig> discoveryConfigs) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(discoveryConfigs) ? 1 : 0) != 0, (Object)"discoveryConfigs should not be null or empty");
        LookupRequest request = new LookupRequest(discoveryConfigs, DeploymentConfig.regionId(), DeploymentConfig.zoneId());
        LookupResponse response = this.request("/artemis/api/discovery/lookup.json", request, LookupResponse.class);
        ResponseStatus status = response.getResponseStatus();
        this.logEvent(status, "discovery", "lookup");
        if (ResponseStatusUtil.isSuccess((ResponseStatus)status)) {
            return response.getServices();
        }
        throw new RuntimeException("lookup services failed. " + status);
    }
}

