/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mydotey.artemis.InstanceChange;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.discovery.ArtemisDiscoveryHttpClient;
import org.mydotey.artemis.client.discovery.ServiceContext;
import org.mydotey.artemis.client.discovery.ServiceRepository;
import org.mydotey.artemis.client.websocket.WebSocketSessionContext;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueConfig;
import org.mydotey.scf.filter.RangeValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class ServiceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscovery.class);
    private final ServiceRepository serviceRepository;
    private final ArtemisDiscoveryHttpClient discoveryHttpClient;
    private final Property<String, Long> ttl;
    private volatile long lastUpdateTime = System.currentTimeMillis();
    private final WebSocketSessionContext sessionContext;
    private final DynamicScheduledThread poller;
    protected final Map<String, DiscoveryConfig> reloadFailedDiscoveryConfigs = Maps.newConcurrentMap();

    public ServiceDiscovery(ServiceRepository serviceRepository, ArtemisClientConfig config) {
        Preconditions.checkArgument((serviceRepository != null ? 1 : 0) != 0, (Object)"ServiceRepository should not be null");
        this.serviceRepository = serviceRepository;
        this.discoveryHttpClient = new ArtemisDiscoveryHttpClient(config);
        this.ttl = config.properties().getLongProperty((Object)config.key("service-discovery.ttl"), Long.valueOf(900000L), (Function)new RangeValueFilter((Comparable)Long.valueOf(60000L), (Comparable)Long.valueOf(86400000L)));
        this.sessionContext = new WebSocketSessionContext(config){

            @Override
            protected void afterConnectionEstablished(WebSocketSession session) {
                ServiceDiscovery.this.subscribe(session);
            }

            @Override
            protected void handleMessage(WebSocketSession session, WebSocketMessage<?> message) {
                try {
                    InstanceChange instanceChange = (InstanceChange)JacksonJsonCodec.DEFAULT.decode(((String)message.getPayload()).getBytes(), InstanceChange.class);
                    ServiceDiscovery.this.onInstanceChange(instanceChange);
                }
                catch (Throwable e) {
                    logger.warn("convert message failed", e);
                }
            }
        };
        this.sessionContext.start();
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(config.properties(), new RangeValueConfig((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(200)), new RangeValueConfig((Comparable)Integer.valueOf(60000), (Comparable)Integer.valueOf(60000), (Comparable)Integer.valueOf(86400000)));
        this.poller = new DynamicScheduledThread(config.key("service-discovery"), () -> {
            try {
                this.reload(this.getReloadDiscoveryConfigs());
            }
            catch (Throwable t) {
                logger.warn("reload services failed", t);
            }
        }, dynamicScheduledThreadConfig);
        this.poller.setDaemon(true);
        this.poller.start();
    }

    public void registerDiscoveryConfig(DiscoveryConfig config) {
        this.subscribe(this.sessionContext.get(), config);
    }

    public Service getService(DiscoveryConfig config) {
        return this.discoveryHttpClient.getService(config);
    }

    protected void onServiceChange(Service service) {
        this.serviceRepository.update(service);
    }

    protected void onInstanceChange(InstanceChange instanceChange) {
        String serviceId = instanceChange.getInstance().getServiceId();
        if ("reload".equals(instanceChange.getChangeType())) {
            this.reload(this.serviceRepository.getDiscoveryConfig(serviceId));
        } else {
            this.serviceRepository.update(instanceChange);
        }
    }

    protected List<DiscoveryConfig> getReloadDiscoveryConfigs() {
        if (this.expired()) {
            return this.serviceRepository.getDiscoveryConfigs();
        }
        HashMap discoveryConfigs = Maps.newHashMap(this.reloadFailedDiscoveryConfigs);
        ArrayList configs = Lists.newArrayList(discoveryConfigs.values());
        for (ServiceContext serviceContext : this.serviceRepository.getServices()) {
            if (discoveryConfigs.containsKey(serviceContext.getDiscoveryConfig().getServiceId()) || serviceContext.isAvailable()) continue;
            configs.add(serviceContext.getDiscoveryConfig());
        }
        return configs;
    }

    protected void reload(DiscoveryConfig ... configs) {
        this.reload(Lists.newArrayList((Object[])configs));
    }

    protected void reload(List<DiscoveryConfig> configs) {
        try {
            if (CollectionUtils.isEmpty(configs)) {
                return;
            }
            logger.info("start reload services.");
            List<Service> services = this.discoveryHttpClient.getServices(configs);
            for (Service service : services) {
                String serviceId;
                if (service == null || StringExtension.isBlank((String)(serviceId = service.getServiceId()))) continue;
                this.onServiceChange(service);
                this.reloadFailedDiscoveryConfigs.remove(serviceId.toLowerCase());
            }
            this.lastUpdateTime = System.currentTimeMillis();
            logger.info("end reload services");
        }
        catch (Throwable t) {
            for (DiscoveryConfig config : configs) {
                String serviceId;
                if (config == null || StringExtension.isBlank((String)(serviceId = config.getServiceId()))) continue;
                this.reloadFailedDiscoveryConfigs.put(serviceId.toLowerCase(), config);
            }
            throw t;
        }
    }

    protected void subscribe(WebSocketSession session) {
        try {
            for (DiscoveryConfig discoveryConfig : this.serviceRepository.getDiscoveryConfigs()) {
                this.subscribe(session, discoveryConfig);
            }
        }
        catch (Throwable e) {
            logger.warn("subscribe services failed", e);
        }
    }

    protected void subscribe(WebSocketSession session, DiscoveryConfig discoveryConfig) {
        try {
            if (discoveryConfig == null) {
                return;
            }
            if (session == null) {
                return;
            }
            TextMessage message = new TextMessage((CharSequence)new String(JacksonJsonCodec.DEFAULT.encode((Object)discoveryConfig)));
            session.sendMessage((WebSocketMessage)message);
        }
        catch (Throwable e) {
            logger.warn("subscribe service failed", e);
        }
    }

    protected boolean expired() {
        return System.currentTimeMillis() - this.lastUpdateTime >= (Long)this.ttl.getValue();
    }
}

