/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.InstanceChange;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.client.ServiceChangeEvent;
import org.mydotey.artemis.client.ServiceChangeListener;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.discovery.ServiceContext;
import org.mydotey.artemis.client.discovery.ServiceDiscovery;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.caravan.util.metric.EventMetric;
import org.mydotey.caravan.util.metric.EventMetricManager;
import org.mydotey.caravan.util.metric.MetricConfig;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRepository {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRepository.class);
    private final ConcurrentHashMap<String, ServiceContext> services = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DiscoveryConfig> discoveryConfigs = new ConcurrentHashMap();
    private final ExecutorService serviceChangeCallback = Executors.newSingleThreadExecutor();
    private final String serviceDiscoveryMetricName;
    private final EventMetricManager eventMetricManager;
    protected final ServiceDiscovery serviceDiscovery;

    public ServiceRepository(ArtemisClientConfig config) {
        this(config, null);
    }

    protected ServiceRepository(ArtemisClientConfig config, ServiceDiscovery serviceDiscovery) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ArtemisClientConfig should not be null");
        this.serviceDiscoveryMetricName = config.key("service-discovery.instance-change.event.distribution");
        this.eventMetricManager = config.eventMetricManager();
        this.serviceDiscovery = serviceDiscovery == null ? new ServiceDiscovery(this, config) : serviceDiscovery;
    }

    public boolean containsService(String serviceId) {
        if (StringExtension.isBlank((String)serviceId)) {
            return false;
        }
        return this.services.containsKey(serviceId.toLowerCase());
    }

    public List<DiscoveryConfig> getDiscoveryConfigs() {
        return Lists.newArrayList(this.discoveryConfigs.values());
    }

    public DiscoveryConfig getDiscoveryConfig(String serviceId) {
        if (StringExtension.isBlank((String)serviceId)) {
            return null;
        }
        return this.discoveryConfigs.get(serviceId.toLowerCase());
    }

    public List<ServiceContext> getServices() {
        return Lists.newArrayList(this.services.values());
    }

    public Service getService(DiscoveryConfig discoveryConfig) {
        if (discoveryConfig == null) {
            return new Service();
        }
        String serviceId = StringExtension.toLowerCase((String)discoveryConfig.getServiceId());
        if (StringExtension.isBlank((String)serviceId)) {
            return new Service();
        }
        if (!this.containsService(serviceId)) {
            this.registerService(discoveryConfig);
        }
        return this.services.get(serviceId).newService();
    }

    public void registerServiceChangeListener(DiscoveryConfig discoveryConfig, ServiceChangeListener listener) {
        if (discoveryConfig == null || listener == null) {
            return;
        }
        String serviceId = StringExtension.toLowerCase((String)discoveryConfig.getServiceId());
        if (StringExtension.isBlank((String)serviceId)) {
            return;
        }
        if (!this.containsService(serviceId)) {
            this.registerService(discoveryConfig);
        }
        this.services.get(serviceId).addListener(listener);
    }

    private synchronized void registerService(DiscoveryConfig discoveryConfig) {
        if (discoveryConfig == null) {
            return;
        }
        String serviceId = StringExtension.toLowerCase((String)discoveryConfig.getServiceId());
        if (this.containsService(serviceId)) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext(discoveryConfig);
        try {
            Service service = this.serviceDiscovery.getService(discoveryConfig);
            serviceContext.setService(service);
        }
        catch (Throwable t) {
            logger.error("init service failed", t);
        }
        this.services.put(serviceId, serviceContext);
        this.discoveryConfigs.put(serviceId, discoveryConfig);
        try {
            this.serviceDiscovery.registerDiscoveryConfig(discoveryConfig);
        }
        catch (Throwable e) {
            logger.warn(String.format("register the service %s to the %s failed", serviceId, this.serviceDiscovery), e);
        }
    }

    private void notifyServiceChange(final ServiceChangeListener listener, final ServiceChangeEvent event) {
        try {
            if (listener == null || event == null) {
                return;
            }
            this.serviceChangeCallback.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onChange(event);
                    }
                    catch (Throwable e) {
                        logger.error("execute service change listener failed", e);
                    }
                }
            });
        }
        catch (Throwable e) {
            logger.warn("submit service change notification failed", e);
        }
    }

    protected final synchronized void update(Service service) {
        try {
            if (service == null) {
                return;
            }
            String serviceId = service.getServiceId();
            if (serviceId == null) {
                return;
            }
            ServiceContext currentContext = this.services.get(serviceId.toLowerCase());
            if (currentContext == null) {
                return;
            }
            currentContext.setService(service);
            ServiceChangeEvent event = currentContext.newServiceChangeEvent("reload");
            for (ServiceChangeListener listener : currentContext.getListeners()) {
                this.notifyServiceChange(listener, event);
            }
            logger.info("Operation:" + event.changeType() + "\nservice: " + new String(JacksonJsonCodec.DEFAULT.encode((Object)service)));
            this.metric(event.changeType(), true, service);
        }
        catch (Throwable e) {
            logger.warn("update service instance failed", e);
        }
    }

    protected final synchronized void update(InstanceChange instanceChange) {
        try {
            String changeType = instanceChange.getChangeType();
            Instance instance = instanceChange.getInstance();
            if (StringExtension.isBlank((String)changeType) || instance == null) {
                return;
            }
            ServiceContext currentContext = this.services.get(instance.getServiceId());
            if (currentContext == null) {
                return;
            }
            boolean updated = false;
            if ("delete".equals(changeType)) {
                updated = currentContext.deleteInstance(instance);
            } else if ("new".equals(changeType)) {
                updated = currentContext.addInstance(instance);
            } else if ("change".equals(changeType)) {
                updated = currentContext.updateInstance(instance);
            } else {
                logger.info("unexpected changeType:" + changeType);
            }
            if (updated) {
                ServiceChangeEvent event = currentContext.newServiceChangeEvent(changeType);
                for (ServiceChangeListener listener : currentContext.getListeners()) {
                    this.notifyServiceChange(listener, event);
                }
                logger.info("Operation:" + changeType + "\nInstance: " + instance);
            }
            this.metric(changeType, updated, instance);
        }
        catch (Throwable e) {
            logger.warn("update service instance failed", e);
        }
    }

    private void metric(String changeType, boolean updated, Service service) {
        if (StringExtension.isBlank((String)changeType) || service == null) {
            return;
        }
        Instance fakeAllInstance = this.getFakeAllInstance(service);
        if (fakeAllInstance == null) {
            return;
        }
        this.metric(changeType, updated, fakeAllInstance);
    }

    private Instance getFakeAllInstance(Service service) {
        List instances = service.getInstances();
        if (CollectionExtension.isEmpty((Collection)instances)) {
            return null;
        }
        Instance sampleInstance = (Instance)instances.get(0);
        if (sampleInstance == null) {
            return null;
        }
        Instance fakeInstance = sampleInstance.clone();
        fakeInstance.setInstanceId("reload");
        return fakeInstance;
    }

    private void metric(String changeType, boolean updated, Instance instance) {
        if (StringExtension.isBlank((String)changeType) || instance == null) {
            return;
        }
        String metricId = "service-discovery." + changeType + "." + updated + "." + instance;
        HashMap metadata = Maps.newHashMap();
        metadata.put("metric_name_distribution", this.serviceDiscoveryMetricName);
        metadata.put("regionId", instance.getRegionId());
        metadata.put("zoneId", instance.getZoneId());
        metadata.put("serviceId", instance.getServiceId());
        metadata.put("updated", updated ? "true" : "false");
        metadata.put("instanceId", instance.getInstanceId());
        EventMetric metric = this.eventMetricManager.getMetric(metricId, new MetricConfig((Map)metadata));
        metric.addEvent(changeType);
    }
}

