/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.ResponseStatus;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.common.ArtemisHttpClient;
import org.mydotey.artemis.registry.RegisterRequest;
import org.mydotey.artemis.registry.RegisterResponse;
import org.mydotey.artemis.registry.UnregisterRequest;
import org.mydotey.artemis.registry.UnregisterResponse;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.springframework.util.CollectionUtils;

public class ArtemisRegistryHttpClient
extends ArtemisHttpClient {
    public ArtemisRegistryHttpClient(ArtemisClientConfig config) {
        super(config, config.key("registry"));
    }

    public void register(Set<Instance> instances) {
        try {
            Preconditions.checkArgument((!CollectionUtils.isEmpty(instances) ? 1 : 0) != 0, (Object)"instances");
            RegisterRequest request = new RegisterRequest((List)Lists.newArrayList(instances));
            RegisterResponse response = this.request("/artemis/api/registry/register.json", request, RegisterResponse.class);
            if (ResponseStatusUtil.isFail((ResponseStatus)response.getResponseStatus())) {
                this._logger.error("register instances failed. Response:" + new String(JacksonJsonCodec.DEFAULT.encode((Object)response)));
            } else if (ResponseStatusUtil.isPartialFail((ResponseStatus)response.getResponseStatus())) {
                this._logger.warn("register instances patial failed. Response:" + new String(JacksonJsonCodec.DEFAULT.encode((Object)response)));
            }
            this.logEvent(response.getResponseStatus(), "registry", "register");
        }
        catch (Throwable e) {
            this._logger.warn("register instances failed", e);
            this.logEvent("registry", "register");
        }
    }

    public void unregister(Set<Instance> instances) {
        try {
            Preconditions.checkArgument((!CollectionUtils.isEmpty(instances) ? 1 : 0) != 0, (Object)"instances");
            UnregisterRequest request = new UnregisterRequest((List)Lists.newArrayList(instances));
            UnregisterResponse response = this.request("/artemis/api/registry/unregister.json", request, UnregisterResponse.class);
            if (ResponseStatusUtil.isFail((ResponseStatus)response.getResponseStatus())) {
                this._logger.error("unregister instances failed. Response:" + new String(JacksonJsonCodec.DEFAULT.encode((Object)response)));
            } else if (ResponseStatusUtil.isPartialFail((ResponseStatus)response.getResponseStatus())) {
                this._logger.warn("unregister instances patial failed. Response:" + new String(JacksonJsonCodec.DEFAULT.encode((Object)response)));
            }
            this.logEvent(response.getResponseStatus(), "registry", "unregister");
        }
        catch (Throwable e) {
            this._logger.warn("unregister instances failed", e);
            this.logEvent("registry", "unregister");
        }
    }
}

