/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.ResponseStatus;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.registry.InstanceRepository;
import org.mydotey.artemis.client.websocket.WebSocketSessionContext;
import org.mydotey.artemis.registry.FailedInstance;
import org.mydotey.artemis.registry.HeartbeatResponse;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.caravan.util.metric.AuditMetric;
import org.mydotey.caravan.util.metric.EventMetric;
import org.mydotey.caravan.util.metric.MetricConfig;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueConfig;
import org.mydotey.scf.filter.RangeValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class InstanceRegistry {
    private static final Logger _logger = LoggerFactory.getLogger(InstanceRegistry.class);
    private final InstanceRepository _instanceRepository;
    private final Property<String, Integer> _ttl;
    private final Property<String, Integer> _interval;
    private volatile long _lastHeartbeatTime;
    private volatile long _heartbeatAcceptStartTime = System.currentTimeMillis();
    private final WebSocketSessionContext _sessionContext;
    private final EventMetric _heartbeatStatus;
    private final AuditMetric _heartbeatPrepareLatency;
    private final AuditMetric _heartbeatSendLatency;
    private final AuditMetric _heartbeatAcceptLatency;
    private final DynamicScheduledThread _heartbeatChecker;

    public InstanceRegistry(InstanceRepository instanceRepository, ArtemisClientConfig config) {
        Preconditions.checkArgument((instanceRepository != null ? 1 : 0) != 0, (Object)"instance repository");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config");
        this._instanceRepository = instanceRepository;
        this._ttl = config.properties().getIntProperty((Object)config.key("instance-registry.instance-ttl"), Integer.valueOf(20000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(5000), (Comparable)Integer.valueOf(86400000)));
        this._interval = config.properties().getIntProperty((Object)config.key("instance-registry.heartbeat-interval"), Integer.valueOf(5000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(500), (Comparable)Integer.valueOf(300000)));
        this._sessionContext = new WebSocketSessionContext(config){

            @Override
            protected void afterConnectionEstablished(WebSocketSession session) {
            }

            @Override
            protected void handleMessage(WebSocketSession session, WebSocketMessage<?> message) {
                InstanceRegistry.this.acceptHeartbeat(message);
            }
        };
        this._sessionContext.start();
        this._heartbeatStatus = config.eventMetricManager().getMetric(config.key("heartbeat.event"), new MetricConfig((Map)ImmutableMap.of((Object)"metric_name_distribution", (Object)config.key("heartbeat.event.distribution"))));
        this._heartbeatPrepareLatency = config.valueMetricManager().getMetric(config.key("heartbeat.prepare-latency"), new MetricConfig((Map)ImmutableMap.of((Object)"metric_name_distribution", (Object)config.key("heartbeat.prepare-latency.distribution"), (Object)"metric_name_audit", (Object)config.key("heartbeat.prepare-latency"))));
        this._heartbeatSendLatency = config.valueMetricManager().getMetric(config.key("heartbeat.send-latency"), new MetricConfig((Map)ImmutableMap.of((Object)"metric_name_distribution", (Object)config.key("heartbeat.send-latency.distribution"), (Object)"metric_name_audit", (Object)config.key("heartbeat.send-latency"))));
        this._heartbeatAcceptLatency = config.valueMetricManager().getMetric(config.key("heartbeat.accept-latency"), new MetricConfig((Map)ImmutableMap.of((Object)"metric_name_distribution", (Object)config.key("heartbeat.accept-latency.distribution"), (Object)"metric_name_audit", (Object)config.key("heartbeat.accept-latency"))));
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(config.properties(), new RangeValueConfig((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3600000)), new RangeValueConfig((Comparable)Integer.valueOf(1000), (Comparable)Integer.valueOf(500), (Comparable)Integer.valueOf(90000)));
        this._heartbeatChecker = new DynamicScheduledThread(config.key("instance-registry.heartbeat-checker"), new Runnable(){

            @Override
            public void run() {
                InstanceRegistry.this.checkHeartbeat();
            }
        }, dynamicScheduledThreadConfig);
        this._heartbeatChecker.setDaemon(true);
        this._heartbeatChecker.start();
    }

    protected void acceptHeartbeat(WebSocketMessage<?> message) {
        try {
            HeartbeatResponse response = (HeartbeatResponse)JacksonJsonCodec.DEFAULT.decode(((String)message.getPayload()).getBytes(), HeartbeatResponse.class);
            ResponseStatus status = response.getResponseStatus();
            if (status == null) {
                this._heartbeatStatus.addEvent("null");
            } else {
                this._heartbeatStatus.addEvent(status.getStatus());
            }
            long heartbeatTime = System.currentTimeMillis() - this._heartbeatAcceptStartTime;
            this._heartbeatAcceptLatency.addValue((double)heartbeatTime);
            if (ResponseStatusUtil.isServiceDown((ResponseStatus)status)) {
                this._sessionContext.markdown();
            }
            if (ResponseStatusUtil.isFail((ResponseStatus)status)) {
                _logger.warn("heartbeat failed: " + status.getMessage());
            } else if (ResponseStatusUtil.isPartialFail((ResponseStatus)status)) {
                _logger.info("heartbeat partial failed: " + status.getMessage());
            }
            this.registerToServicesRegistry(response.getFailedInstances());
        }
        catch (Throwable e) {
            _logger.error("handle heartbeat message failed", e);
        }
    }

    protected void sendHeartbeat() {
        try {
            if (this._sessionContext.get() == null) {
                return;
            }
            long heartbeatPrepareStartTime = System.currentTimeMillis();
            TextMessage message = this._instanceRepository.getHeartbeatMessage();
            this._heartbeatPrepareLatency.addValue((double)(System.currentTimeMillis() - heartbeatPrepareStartTime));
            if (message == null) {
                _logger.info("heartbeat message is null");
                this._lastHeartbeatTime = System.currentTimeMillis();
                return;
            }
            long heartbeatSendStartTime = System.currentTimeMillis();
            this._sessionContext.get().sendMessage((WebSocketMessage)message);
            this._heartbeatSendLatency.addValue((double)(System.currentTimeMillis() - heartbeatSendStartTime));
            this._lastHeartbeatTime = System.currentTimeMillis();
            this._heartbeatAcceptStartTime = System.currentTimeMillis();
        }
        catch (Throwable e) {
            _logger.warn("send heartbeat failed.", e);
        }
    }

    protected void checkHeartbeat() {
        long heartbeatInterval = System.currentTimeMillis() - this._lastHeartbeatTime;
        if (heartbeatInterval >= (long)((Integer)this._ttl.getValue()).intValue()) {
            _logger.warn(String.format("heartbeat interval time is more than %d", this._ttl.getValue()));
            this._sessionContext.markdown();
        }
        if (heartbeatInterval >= (long)((Integer)this._interval.getValue()).intValue()) {
            this.sendHeartbeat();
        }
    }

    protected void registerToServicesRegistry(List<FailedInstance> failedInstances) {
        try {
            if (CollectionUtils.isEmpty(failedInstances)) {
                return;
            }
            HashSet<Instance> instances = new HashSet<Instance>();
            for (FailedInstance fs : failedInstances) {
                if (!"data-not-found".equals(fs.getErrorCode()) && !"unknown".equals(fs.getErrorCode())) continue;
                instances.add(fs.getInstance());
            }
            this._instanceRepository.registerToRemote(instances);
        }
        catch (Throwable e) {
            _logger.warn("register failed instances failed", e);
        }
    }
}

