/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.websocket;

import org.mydotey.artemis.client.common.AddressContext;
import org.mydotey.artemis.client.websocket.WebSocketSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketSessionCallback
implements ListenableFutureCallback<WebSocketSession> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionCallback.class);
    private final AddressContext context;
    private final WebSocketSessionContext webSocketSessionContext;

    public WebSocketSessionCallback(WebSocketSessionContext webSocketSessionContext, AddressContext context) {
        this.webSocketSessionContext = webSocketSessionContext;
        this.context = context;
    }

    public void onFailure(Throwable ex) {
        logger.warn("connect to websocket endpoint failed", ex);
    }

    public void onSuccess(WebSocketSession session) {
        this.webSocketSessionContext.reset(session, this.context);
    }
}

