/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mydotey.artemis.InstanceKey;
import org.mydotey.java.StringExtension;

public class Instance
implements Cloneable {
    private String _regionId;
    private String _zoneId;
    private String _groupId;
    private String _serviceId;
    private String _instanceId;
    private String _machineName;
    private String _ip;
    private int _port;
    private String _protocol;
    private String _url;
    private String _healthCheckUrl;
    private String _status;
    private Map<String, String> _metadata;

    public Instance() {
    }

    public Instance(String regionId, String zoneId, String groupId, String serviceId, String instanceId, String machineName, String ip, int port, String protocol, String url, String healthCheckUrl, String status, Map<String, String> metadata) {
        this._regionId = regionId;
        this._zoneId = zoneId;
        this._groupId = groupId;
        this._serviceId = serviceId;
        this._instanceId = instanceId;
        this._machineName = machineName;
        this._ip = ip;
        this._port = port;
        this._protocol = protocol;
        this._url = url;
        this._healthCheckUrl = healthCheckUrl;
        this._status = status;
        this._metadata = metadata;
    }

    public String getRegionId() {
        return this._regionId;
    }

    public void setRegionId(String regionId) {
        this._regionId = regionId;
    }

    public String getZoneId() {
        return this._zoneId;
    }

    public void setZoneId(String zoneId) {
        this._zoneId = zoneId;
    }

    public String getServiceId() {
        return this._serviceId;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public void setGroupId(String groupId) {
        this._groupId = groupId;
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public void setInstanceId(String instanceId) {
        this._instanceId = instanceId;
    }

    public String getMachineName() {
        return this._machineName;
    }

    public void setMachineName(String machineName) {
        this._machineName = machineName;
    }

    public String getIp() {
        return this._ip;
    }

    public void setIp(String ip) {
        this._ip = ip;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getHealthCheckUrl() {
        return this._healthCheckUrl;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this._healthCheckUrl = healthCheckUrl;
    }

    public String getStatus() {
        return this._status;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public Map<String, String> getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this._metadata = metadata;
    }

    public String toString() {
        String string = this._regionId + "/" + this._zoneId + "/" + this._serviceId;
        if (!StringExtension.isBlank((String)this._groupId)) {
            string = string + "/" + this._groupId;
        }
        string = string + "/" + this._instanceId;
        return string.toLowerCase();
    }

    public int hashCode() {
        return InstanceKey.of(this).hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(InstanceKey.of(this), InstanceKey.of((Instance)other));
    }

    public Instance clone() {
        Instance cloned;
        try {
            cloned = (Instance)super.clone();
        }
        catch (Throwable ex) {
            cloned = new Instance(this._regionId, this._zoneId, this._groupId, this._serviceId, this._instanceId, this._machineName, this._ip, this._port, this._protocol, this._url, this._healthCheckUrl, this._status, this._metadata);
        }
        Map<String, String> metadata = this._metadata;
        if (metadata != null) {
            metadata = new HashMap<String, String>(metadata);
        }
        cloned.setMetadata(metadata);
        return cloned;
    }

    public static interface Status {
        public static final String STARTING = "starting";
        public static final String UP = "up";
        public static final String DOWN = "down";
        public static final String UNHEALTHY = "unhealthy";
        public static final String UNKNOWN = "unknown";
    }
}

