/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis;

import java.util.Objects;
import org.mydotey.artemis.Instance;

public class InstanceKey {
    public static final InstanceKey EMPTY = new InstanceKey(null, null, null){

        @Override
        public void setRegionId(String regionId) {
            throw new IllegalStateException("EMPTY InstanceKey cannot be modified.");
        }

        @Override
        public void setServiceId(String serviceId) {
            throw new IllegalStateException("EMPTY InstanceKey cannot be modified.");
        }

        @Override
        public void setInstanceId(String instanceId) {
            throw new IllegalStateException("EMPTY InstanceKey cannot be modified.");
        }
    };
    private String regionId;
    private String serviceId;
    private String instanceId;

    public static InstanceKey of(Instance instance) {
        if (instance == null) {
            return EMPTY;
        }
        return new InstanceKey(instance.getRegionId(), instance.getServiceId(), instance.getInstanceId());
    }

    public InstanceKey() {
    }

    public InstanceKey(String regionId, String serviceId, String instanceId) {
        this.regionId = regionId;
        this.serviceId = serviceId;
        this.instanceId = instanceId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.regionId, this.serviceId, this.instanceId).toLowerCase();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.toString(), other.toString());
    }
}

