/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.RouteRule;
import org.mydotey.java.StringExtension;

public class Service
implements Cloneable {
    private String serviceId;
    private Map<String, String> metadata;
    private List<Instance> instances;
    private List<Instance> logicInstances;
    private List<RouteRule> routeRules;

    public Service() {
    }

    public Service(String serviceId) {
        this(serviceId, null, null);
    }

    public Service(String serviceId, List<Instance> instances, Map<String, String> metadata) {
        this.serviceId = serviceId;
        this.metadata = metadata;
        this.instances = instances;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<Instance> instances) {
        this.instances = instances;
    }

    public List<Instance> getLogicInstances() {
        return this.logicInstances;
    }

    public void setLogicInstances(List<Instance> logicInstances) {
        this.logicInstances = logicInstances;
    }

    public List<RouteRule> getRouteRules() {
        return this.routeRules;
    }

    public void setRouteRules(List<RouteRule> routeRules) {
        this.routeRules = routeRules;
    }

    public String toString() {
        return this.serviceId;
    }

    public int hashCode() {
        String serviceId = StringExtension.toLowerCase((String)this.serviceId);
        return serviceId == null ? 0 : serviceId.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        String serviceId = StringExtension.toLowerCase((String)this.serviceId);
        String otherServiceId = StringExtension.toLowerCase((String)((Service)other).serviceId);
        return Objects.equals(serviceId, otherServiceId);
    }

    public Service clone() {
        Service cloned;
        try {
            cloned = (Service)super.clone();
        }
        catch (Throwable ex) {
            cloned = new Service(this.serviceId, this.instances, this.metadata);
        }
        Map<String, String> metadata = this.metadata;
        if (metadata != null) {
            metadata = new HashMap<String, String>(metadata);
        }
        cloned.setMetadata(metadata);
        List<Instance> instances = this.instances;
        if (instances != null) {
            instances = new ArrayList<Instance>(instances);
        }
        cloned.setInstances(instances);
        List<Instance> logicInstances = this.logicInstances;
        if (logicInstances != null) {
            logicInstances = new ArrayList<Instance>(logicInstances);
        }
        cloned.setLogicInstances(logicInstances);
        return cloned;
    }
}

