/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mydotey.artemis.Instance;

public class ServiceGroup
implements Cloneable {
    private String groupKey;
    private Integer weight;
    private List<String> instanceIds;
    private List<Instance> instances;
    private Map<String, String> metadata;

    public ServiceGroup() {
        this(null, null);
    }

    public ServiceGroup(String groupKey, Integer weight) {
        this(groupKey, weight, null, null);
    }

    public ServiceGroup(String groupKey, Integer weight, List<Instance> instances, Map<String, String> metadata) {
        this.groupKey = groupKey;
        this.weight = weight;
        this.instances = instances;
        this.metadata = metadata;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<Instance> instances) {
        this.instances = instances;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ServiceGroup clone() {
        ServiceGroup cloned = new ServiceGroup(this.groupKey, this.weight, this.instances, this.metadata);
        Map<String, String> metadata = this.metadata;
        if (metadata != null) {
            metadata = new HashMap<String, String>(metadata);
        }
        cloned.setMetadata(metadata);
        return cloned;
    }
}

