/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.config;

import java.util.ArrayList;
import org.mydotey.java.StringExtension;
import org.mydotey.java.net.NetworkInterfaceManager;
import org.mydotey.scf.ConfigurationManager;
import org.mydotey.scf.Property;
import org.mydotey.scf.facade.ConfigurationManagers;
import org.mydotey.scf.facade.SimpleConfigurationSources;
import org.mydotey.scf.facade.StringProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploymentConfig {
    private static final String DEPLOYMENT_ENV_PROPERTY_NAME = "deployment.env";
    private static final String PROPERTIES_FILE_NAME = "application";
    private static final String REGION_ID_PROPERTY_KEY = "region.id";
    private static final String ZONE_ID_PROPERTY_KEY = "zone.id";
    private static final String APPID_PROPERTY_KEY = "app.id";
    private static final String PORT_PROPERTY_KEY = "app.port";
    private static final String PROTOCOL_PROPERTY_KEY = "app.protocol";
    private static final String PATH_PROPERTY_KEY = "app.path";
    private static final Logger _logger = LoggerFactory.getLogger(DeploymentConfig.class);
    private static String _deploymentEnv = System.getProperty("deployment.env");
    private static StringProperties _properties;
    private static Property<String, String> _regionIdProperty;
    private static Property<String, String> _zoneIdProperty;
    private static Property<String, String> _appIdProperty;
    private static Property<String, Integer> _portProperty;
    private static Property<String, String> _protocolProperty;
    private static Property<String, String> _pathProperty;
    private static String _regionId;
    private static String _zoneId;
    private static String _appId;
    private static String _machineName;
    private static String _ip;
    private static int _port;
    private static String _protocol;
    private static String _path;

    public static StringProperties properties() {
        return _properties;
    }

    public static String deploymentEnv() {
        return _deploymentEnv;
    }

    public static String regionId() {
        return _regionId;
    }

    public static String zoneId() {
        return _zoneId;
    }

    public static String appId() {
        return _appId;
    }

    public static String machineName() {
        return _machineName;
    }

    public static String ip() {
        return _ip;
    }

    public static int port() {
        return _port;
    }

    public static String protocol() {
        return _protocol;
    }

    public static String path() {
        return _path;
    }

    private static void logDeploymentInfo() {
        _logger.info("DeploymentConfig is initialized. deploymentEnv: {}, regionId: {}, zoneId: {}, appId: {}, machineName: {}, ip: {}, port: {}, protocol: {}, path: {}", new Object[]{_deploymentEnv, _regionId, _zoneId, _appId, _machineName, _ip, _port, _protocol, _path});
    }

    private DeploymentConfig() {
    }

    static {
        _deploymentEnv = StringExtension.isBlank((String)_deploymentEnv) ? null : _deploymentEnv.trim().toLowerCase();
        ArrayList<Object> sources = new ArrayList<Object>();
        sources.add(SimpleConfigurationSources.newEnvironmentVariableSource());
        sources.add(SimpleConfigurationSources.newSystemPropertiesSource());
        if (!StringExtension.isBlank((String)_deploymentEnv)) {
            sources.add(SimpleConfigurationSources.newPropertiesFileSource((String)("application-" + DeploymentConfig.deploymentEnv())));
        }
        sources.add(SimpleConfigurationSources.newPropertiesFileSource((String)PROPERTIES_FILE_NAME));
        ConfigurationManager manager = ConfigurationManagers.newManager((String)"deployment", sources);
        _properties = new StringProperties(manager);
        _regionIdProperty = _properties.getStringProperty((Object)REGION_ID_PROPERTY_KEY);
        _zoneIdProperty = _properties.getStringProperty((Object)ZONE_ID_PROPERTY_KEY);
        _appIdProperty = _properties.getStringProperty((Object)APPID_PROPERTY_KEY);
        _portProperty = _properties.getIntProperty((Object)PORT_PROPERTY_KEY, Integer.valueOf(8080), v -> v >= 1 && v <= 65535 ? v : null);
        _protocolProperty = _properties.getStringProperty((Object)PROTOCOL_PROPERTY_KEY, "http");
        _pathProperty = _properties.getStringProperty((Object)PATH_PROPERTY_KEY);
        _regionId = (String)_regionIdProperty.getValue();
        _zoneId = (String)_zoneIdProperty.getValue();
        _appId = (String)_appIdProperty.getValue();
        _port = (Integer)_portProperty.getValue();
        _protocol = (String)_protocolProperty.getValue();
        _path = (String)_pathProperty.getValue();
        _machineName = NetworkInterfaceManager.INSTANCE.hostName();
        _ip = NetworkInterfaceManager.INSTANCE.hostIP();
        DeploymentConfig.logDeploymentInfo();
    }
}

