/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.KeyValuePair;
import org.mydotey.scf.type.AbstractTypeConverter;

public class ListMultimapConverter
extends AbstractTypeConverter<String, ListMultimap<String, String>> {
    public static final ListMultimapConverter DEFAULT = new ListMultimapConverter();

    public ListMultimapConverter() {
        super(String.class, ListMultimap.class);
    }

    public ListMultimap<String, String> convert(String source) {
        String[] pairValues;
        if (StringExtension.isBlank((String)source)) {
            return null;
        }
        source = source.trim();
        ArrayListMultimap listMultimap = ArrayListMultimap.create();
        for (String pairValue : pairValues = source.trim().split(";")) {
            String[] sources;
            KeyValuePair pair = KeyValuePair.parse((String)pairValue);
            if (pair == null) continue;
            for (String item : sources = ((String)pair.getValue()).split(",")) {
                if (StringExtension.isBlank((String)item)) continue;
                listMultimap.put(pair.getKey(), (Object)item.trim());
            }
        }
        return listMultimap.size() == 0 ? null : listMultimap;
    }
}

