/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.taskdispatcher;

import org.mydotey.artemis.taskdispatcher.Task;
import org.mydotey.artemis.taskdispatcher.TaskAcceptor;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;

class SingleItemTaskAcceptor<T extends Task>
extends TaskAcceptor<T, T> {
    public SingleItemTaskAcceptor(String dispatcherId) {
        super(dispatcherId);
    }

    @Override
    protected int getWorkSize(T w) {
        return 1;
    }

    @Override
    protected boolean isEmptyWork(T work) {
        return work == null;
    }

    @Override
    protected T filterExpiredTask(T work) {
        if (this.isExpiredTask(work)) {
            ArtemisTraceExecutor.INSTANCE.markEvent(this._taskStatusEventType, "expired");
            this._taskStatusEventMetric.addEvent("expired");
            return null;
        }
        ArtemisTraceExecutor.INSTANCE.markEvent(this._taskStatusEventType, "normal");
        this._taskStatusEventMetric.addEvent("normal");
        return work;
    }

    @Override
    protected void assignWork() {
        while (!this._processingOrder.isEmpty()) {
            String taskId = (String)this._processingOrder.poll();
            Task task = (Task)this._acceptedTasks.remove(taskId);
            if (this.isBufferFull()) {
                this._workQueue.poll();
                this._pendingTaskCount.decrementAndGet();
                ArtemisTraceExecutor.INSTANCE.markEvent(this._workStatusEventType, "buffer-full-dropped");
                this._workStatusEventMetric.addEvent("buffer-full-dropped");
            }
            this._workQueue.add(task);
            this._pendingTaskCount.incrementAndGet();
            ArtemisTraceExecutor.INSTANCE.markEvent(this._workStatusEventType, "normal");
            this._workStatusEventMetric.addEvent("normal");
        }
    }
}

