/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.taskdispatcher;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.config.MapValueConverter;
import org.mydotey.artemis.config.MapValueCorrector;
import org.mydotey.artemis.taskdispatcher.TaskErrorCode;
import org.mydotey.java.ObjectExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.PipelineValueFilter;
import org.mydotey.scf.type.AbstractTypeConverter;
import org.mydotey.scf.type.TypeConverter;
import org.mydotey.scf.type.string.StringToIntConverter;
import org.mydotey.scf.type.string.StringToMapConverter;

class TrafficShaper {
    private static final String IDENTITY_FORMAT = ".traffic-shaper";
    private static final int DEFAULT_FAIL_DELAY = 10;
    private static final int MAX_FAIL_DELAY = 10000;
    private String _trafficShaperId;
    private TypeConverter<Map<String, String>, Map<TaskErrorCode, String>> _failDelayValueConverter = this.createValueConverter();
    private TypeConverter<String, Map<TaskErrorCode, Integer>> _failDelayValueParser = this.createValueParser();
    private Function<Map<TaskErrorCode, Integer>, Map<TaskErrorCode, Integer>> _failDelayValueCorrector = this.createValueCorrector();
    private Property<String, Map<TaskErrorCode, Integer>> _failDelayProperty;
    private ConcurrentHashMap<TaskErrorCode, AtomicLong> _lastFailTimeMap = new ConcurrentHashMap();

    public TrafficShaper(String dispatchId) {
        ObjectExtension.requireNonBlank((String)dispatchId, (String)"dispatchId");
        this._trafficShaperId = dispatchId + IDENTITY_FORMAT;
        this._failDelayProperty = ArtemisConfig.properties().getProperty((Object)(this._trafficShaperId + ".fail-delay"), new HashMap(), this._failDelayValueParser, this._failDelayValueCorrector);
    }

    public void markFail(TaskErrorCode errorCode) {
        ObjectExtension.requireNonNull((Object)((Object)errorCode), (String)"errorCode");
        AtomicLong lastResultTime = this._lastFailTimeMap.computeIfAbsent(errorCode, k -> new AtomicLong());
        lastResultTime.set(System.currentTimeMillis());
    }

    public int transmissionDelay() {
        for (TaskErrorCode errorCode : this._lastFailTimeMap.keySet()) {
            AtomicLong lastResultTime = this._lastFailTimeMap.get((Object)errorCode);
            long time = lastResultTime.get();
            if (time == 0L) continue;
            int failDelay = this.getFailDelay(errorCode);
            long delay = System.currentTimeMillis() - time;
            if (delay >= 0L && delay < (long)failDelay) {
                return (int)((long)failDelay - delay);
            }
            lastResultTime.set(0L);
        }
        return 0;
    }

    private int getFailDelay(TaskErrorCode errorCode) {
        Map getValue = (Map)this._failDelayProperty.getValue();
        Integer delay = (Integer)getValue.get((Object)errorCode);
        return delay == null ? 0 : delay;
    }

    private TypeConverter<Map<String, String>, Map<TaskErrorCode, String>> createValueConverter() {
        return new AbstractTypeConverter<Map<String, String>, Map<TaskErrorCode, String>>(Map.class, Map.class){

            public Map<TaskErrorCode, String> convert(Map<String, String> source) {
                HashMap<TaskErrorCode, String> errorCodeMap = new HashMap<TaskErrorCode, String>();
                for (Map.Entry<String, String> item : source.entrySet()) {
                    errorCodeMap.put(TaskErrorCode.valueOf(item.getKey()), item.getValue());
                }
                return errorCodeMap;
            }
        };
    }

    private TypeConverter<String, Map<TaskErrorCode, Integer>> createValueParser() {
        return new AbstractTypeConverter<String, Map<TaskErrorCode, Integer>>(String.class, Map.class){

            public Map<TaskErrorCode, Integer> convert(String value) {
                Map mapValue = StringToMapConverter.DEFAULT.convert(value);
                Map mapValue2 = (Map)TrafficShaper.this._failDelayValueConverter.convert((Object)mapValue);
                return new MapValueConverter(StringToIntConverter.DEFAULT).convert(mapValue2);
            }
        };
    }

    private Function<Map<TaskErrorCode, Integer>, Map<TaskErrorCode, Integer>> createValueCorrector() {
        PipelineValueFilter corrector = new PipelineValueFilter(Arrays.asList(v -> v == null ? 10 : v, v -> v >= 0 && v <= 10000 ? v : null));
        return new PipelineValueFilter(Arrays.asList(v -> v == null ? new HashMap() : v, new MapValueCorrector(corrector)));
    }
}

