/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.util;

import org.mydotey.artemis.Zone;
import org.mydotey.artemis.checker.ValueChecker;
import org.mydotey.artemis.config.DeploymentConfig;
import org.mydotey.artemis.util.SameRegionChecker;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;

public class SameZoneChecker
implements ValueChecker<Zone> {
    public static final SameZoneChecker DEFAULT = new SameZoneChecker();

    @Override
    public void check(String zoneId, String valueName) {
        if (!this.isSameZone(zoneId)) {
            throw new IllegalArgumentException(valueName + " is not the current zone. expected: " + DeploymentConfig.zoneId() + ", actual: " + zoneId);
        }
    }

    @Override
    public void check(Zone value, String valueName) {
        ObjectExtension.requireNonNull((Object)value, (String)valueName);
        SameRegionChecker.DEFAULT.check(value.getRegionId(), valueName);
        this.check(value.getZoneId(), valueName);
    }

    public boolean isSameZone(String zoneId) {
        if (StringExtension.isBlank((String)zoneId)) {
            return false;
        }
        return zoneId.equalsIgnoreCase(DeploymentConfig.zoneId());
    }
}

