/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.util;

import com.google.common.base.Splitter;
import java.util.List;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.Region;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.ServiceGroupKey;
import org.mydotey.artemis.Zone;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.util.ServiceGroups;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;
import org.mydotey.java.io.file.FileExtension;

public final class ServiceGroupKeys {
    private ServiceGroupKeys() {
    }

    public static ServiceGroupKey of(Service service) {
        ObjectExtension.requireNonNull((Object)service, (String)"service");
        return ServiceGroupKeys.of(service.getServiceId());
    }

    public static ServiceGroupKey of(Service service, Region region) {
        ObjectExtension.requireNonNull((Object)service, (String)"service");
        ObjectExtension.requireNonNull((Object)region, (String)"region");
        return ServiceGroupKeys.of(service.getServiceId(), region.getRegionId());
    }

    public static ServiceGroupKey of(Service service, Zone zone) {
        ObjectExtension.requireNonNull((Object)service, (String)"service");
        ObjectExtension.requireNonNull((Object)zone, (String)"zone");
        return ServiceGroupKeys.of(service.getServiceId(), zone.getRegionId(), zone.getZoneId());
    }

    public static ServiceGroupKey of(Instance instance) {
        ObjectExtension.requireNonNull((Object)instance, (String)"instance");
        String groupId = instance.getGroupId();
        groupId = ServiceGroups.isDefaultGroupId(groupId) ? "default" : groupId;
        return ServiceGroupKeys.of(instance.getServiceId(), instance.getRegionId(), instance.getZoneId(), groupId, instance.getInstanceId());
    }

    public static ServiceGroupKey of(String ... groupIds) {
        ValueCheckers.notNullOrEmpty(groupIds, "groupIds");
        String groupKey = StringExtension.toLowerCase((String)FileExtension.concatPathParts((String[])groupIds));
        return new ServiceGroupKey(groupKey);
    }

    public static List<String> toGroupIdList(ServiceGroupKey serviceGroupKey) {
        ObjectExtension.requireNonNull((Object)serviceGroupKey, (String)"serviceGroupKey");
        return ServiceGroupKeys.toGroupIdList(serviceGroupKey.getGroupKey());
    }

    public static List<String> toGroupIdList(String serviceGroupKey) {
        ObjectExtension.requireNonNull((Object)serviceGroupKey, (String)"serviceGroupKey");
        return Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)serviceGroupKey.toLowerCase());
    }
}

