/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis;

import java.util.Objects;
import org.mydotey.artemis.Instance;

public class ServerKey {
    public static final ServerKey EMPTY = new ServerKey(null, null){

        @Override
        public void setRegionId(String regionId) {
            throw new IllegalStateException("EMPTY ServerKey cannot be modified.");
        }

        @Override
        public void setServerId(String serverId) {
            throw new IllegalStateException("EMPTY ServerKey cannot be modified.");
        }
    };
    private String regionId;
    private String serverId;

    public static ServerKey of(Instance instance) {
        if (instance == null) {
            return EMPTY;
        }
        return new ServerKey(instance.getRegionId(), instance.getIp());
    }

    public ServerKey() {
    }

    public ServerKey(String regionId, String serverId) {
        this.regionId = regionId;
        this.serverId = serverId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String toString() {
        return String.format("%s.%s", this.regionId, this.serverId).toLowerCase();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.toString(), other.toString());
    }
}

