/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.cluster;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mydotey.artemis.Zone;
import org.mydotey.artemis.cluster.ClusterChangeEvent;
import org.mydotey.artemis.cluster.ClusterChangeListener;
import org.mydotey.artemis.cluster.ServiceNode;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;
import org.mydotey.scf.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCluster {
    private static final Logger _logger = LoggerFactory.getLogger(ServiceCluster.class);
    private Property<String, ListMultimap<String, String>> _clusterNodesProperty = ArtemisConfig.getListMultimapProperty("artemis.service.cluster.nodes", (ListMultimap<String, String>)ArrayListMultimap.create());
    private String _regionId;
    private ListMultimap<Zone, ServiceNode> _clusterNodes = ArrayListMultimap.create();
    private List<ClusterChangeListener> _clusterChangeListeners = new ArrayList<ClusterChangeListener>();

    public ServiceCluster(String regionId) {
        ObjectExtension.requireNonBlank((String)regionId, (String)"regionId");
        this._regionId = regionId;
        _logger.info("ServiceCluster is initialized with regionId: " + this._regionId);
        this.updateClusterNodes();
        this._clusterNodesProperty.addChangeListener(event -> {
            this.updateClusterNodes();
            ClusterChangeEvent clusterChangeEvent = new ClusterChangeEvent();
            for (ClusterChangeListener listener : this._clusterChangeListeners) {
                try {
                    listener.onChange(clusterChangeEvent);
                }
                catch (Throwable ex) {
                    _logger.error("ClusterChangeListener onChange failed.", ex);
                }
            }
        });
    }

    public String regionId() {
        return this._regionId;
    }

    public ListMultimap<Zone, ServiceNode> clusterNodes() {
        return this._clusterNodes;
    }

    public synchronized void addClusterChangeListener(ClusterChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        this._clusterChangeListeners.add(listener);
    }

    protected void updateClusterNodes() {
        ListMultimap zoneIdNodeUrlsMap = (ListMultimap)this._clusterNodesProperty.getValue();
        _logger.info("ClusterNodes setting raw value: " + this._clusterNodesProperty.getValue() + ", getValue: " + zoneIdNodeUrlsMap);
        ArrayListMultimap clusterNodes = ArrayListMultimap.create();
        for (String zoneId : zoneIdNodeUrlsMap.keySet()) {
            Zone zone = new Zone(this._regionId, zoneId);
            for (String serviceUrl : zoneIdNodeUrlsMap.get((Object)zoneId)) {
                if (StringExtension.isBlank((String)serviceUrl)) continue;
                ServiceNode peerNode = new ServiceNode(zone, serviceUrl);
                clusterNodes.put((Object)zone, (Object)peerNode);
            }
        }
        if (clusterNodes.size() == 0) {
            _logger.warn("New ClusterNodes is empty. Skip to update");
            return;
        }
        _logger.info("ClusterNodes is updated. from: " + this._clusterNodes + ", to: " + clusterNodes);
        this._clusterNodes = clusterNodes;
    }
}

