/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.config;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import org.mydotey.artemis.config.DeploymentConfig;
import org.mydotey.artemis.config.ListMultimapConverter;
import org.mydotey.java.StringExtension;
import org.mydotey.java.net.NetworkInterfaceManager;
import org.mydotey.scf.ConfigurationManager;
import org.mydotey.scf.ConfigurationSource;
import org.mydotey.scf.Property;
import org.mydotey.scf.facade.ConfigurationManagers;
import org.mydotey.scf.facade.SimpleConfigurationSources;
import org.mydotey.scf.facade.StringProperties;
import org.mydotey.scf.source.cascaded.CascadedConfigurationSource;
import org.mydotey.scf.source.pipeline.PipelineConfigurationSource;
import org.mydotey.scf.type.TypeConverter;

public final class ArtemisConfig {
    private static final String PROPERTIES_FILE_NAME = "artemis";
    private static final String[] CASCADED_FACTORS = new String[]{NetworkInterfaceManager.INSTANCE.hostIP()};
    private static StringProperties _properties;

    public static StringProperties properties() {
        return _properties;
    }

    public static Property<String, ListMultimap<String, String>> getListMultimapProperty(String key, ListMultimap<String, String> defaultValue) {
        return _properties.getProperty((Object)key, defaultValue, (TypeConverter)ListMultimapConverter.DEFAULT);
    }

    static {
        ArrayList<Object> sources = new ArrayList<Object>();
        sources.add(SimpleConfigurationSources.newEnvironmentVariableSource());
        sources.add(SimpleConfigurationSources.newSystemPropertiesSource());
        if (!StringExtension.isBlank((String)DeploymentConfig.deploymentEnv())) {
            sources.add(SimpleConfigurationSources.newPropertiesFileSource((String)("artemis-" + DeploymentConfig.deploymentEnv())));
        }
        sources.add(SimpleConfigurationSources.newPropertiesFileSource((String)PROPERTIES_FILE_NAME));
        PipelineConfigurationSource pipelineConfigurationSource = SimpleConfigurationSources.newPipelineSource(sources);
        CascadedConfigurationSource cascadedConfigurationSource = SimpleConfigurationSources.newCascadedSource((ConfigurationSource)pipelineConfigurationSource, (String[])CASCADED_FACTORS);
        ConfigurationManager manager = ConfigurationManagers.newManager((String)PROPERTIES_FILE_NAME, (ConfigurationSource[])new ConfigurationSource[]{cascadedConfigurationSource});
        _properties = new StringProperties(manager);
    }
}

