/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.discovery;

import java.util.HashMap;
import java.util.Map;

public class DiscoveryConfig
implements Cloneable {
    public static final String DISCOVERY_GENERIC_SERVICE_ID = "discovery_generic_service_id";
    public static final DiscoveryConfig GENERIC = new DiscoveryConfig("discovery_generic_service_id", (Map)new HashMap()){

        @Override
        public void setServiceId(String serviceId) {
            throw new IllegalStateException("GENERIC config cannot be modified.");
        }

        @Override
        public void setRegionId(String regionId) {
            throw new IllegalStateException("GENERIC config cannot be modified.");
        }

        @Override
        public void setZoneId(String zoneId) {
            throw new IllegalStateException("GENERIC config cannot be modified.");
        }

        @Override
        public void setDiscoveryData(Map<String, String> discoveryData) {
            throw new IllegalStateException("GENERIC config cannot be modified.");
        }
    };
    private String serviceId;
    private String regionId;
    private String zoneId;
    private Map<String, String> discoveryData;

    public static boolean isGenericConfig(DiscoveryConfig discoveryConfig) {
        return discoveryConfig != null && DISCOVERY_GENERIC_SERVICE_ID.equals(discoveryConfig.getServiceId());
    }

    public DiscoveryConfig() {
    }

    public DiscoveryConfig(String serviceId) {
        this(serviceId, null);
    }

    public DiscoveryConfig(String serviceId, Map<String, String> discoveryData) {
        this.serviceId = serviceId;
        this.discoveryData = discoveryData;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public Map<String, String> getDiscoveryData() {
        return this.discoveryData;
    }

    public void setDiscoveryData(Map<String, String> discoveryData) {
        this.discoveryData = discoveryData;
    }

    public DiscoveryConfig clone() {
        DiscoveryConfig cloned = new DiscoveryConfig(this.serviceId);
        cloned.discoveryData = this.discoveryData == null ? null : new HashMap<String, String>(this.discoveryData);
        return cloned;
    }

    public String toString() {
        return "DiscoveryConfig{serviceId='" + this.serviceId + '\'' + ", regionId='" + this.regionId + '\'' + ", zoneId='" + this.zoneId + '\'' + ", discoveryData=" + this.discoveryData + '}';
    }
}

