/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.lease;

import java.util.concurrent.locks.ReentrantLock;
import org.mydotey.artemis.lease.LeaseManager;
import org.mydotey.scf.Property;

public class Lease<T> {
    private Property<String, Integer> _ttlProperty;
    private LeaseManager<T> _leaseManager;
    private long _creationTime;
    private volatile long _renewalTime;
    private volatile long _evictionTime;
    private volatile boolean _isExpired;
    private T _data;
    private ReentrantLock _lock = new ReentrantLock();

    Lease(LeaseManager<T> leaseManager, T data, Property<String, Integer> ttlProperty) {
        this._leaseManager = leaseManager;
        this._data = data;
        this._ttlProperty = ttlProperty;
        this._renewalTime = this._creationTime = System.currentTimeMillis();
    }

    public long creationTime() {
        return this._creationTime;
    }

    public long renewalTime() {
        return this._renewalTime;
    }

    public long evictionTime() {
        return this._evictionTime;
    }

    public long ttl() {
        return ((Integer)this._ttlProperty.getValue()).intValue();
    }

    public T data() {
        return this._data;
    }

    protected boolean isExpired() {
        if (this._isExpired) {
            return true;
        }
        this._isExpired = System.currentTimeMillis() > this.renewalTime() + this.ttl() || this.isEvicted();
        return this._isExpired;
    }

    protected boolean isEvicted() {
        return this.evictionTime() > 0L;
    }

    public boolean renew() {
        if (!this.tryLock()) {
            return false;
        }
        try {
            if (this.isExpired()) {
                boolean bl = false;
                return bl;
            }
            this._renewalTime = System.currentTimeMillis();
            this._leaseManager.leaseUpdateSafeChecker().markUpdate();
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseLock();
        }
    }

    public void evict() {
        if (this._evictionTime != 0L) {
            return;
        }
        this._evictionTime = System.currentTimeMillis();
    }

    public String toString() {
        return String.format("{ data: %s, creationTime: %s, renewalTime: %s, evictionTime: %s, ttl: %s }", this.data(), this.creationTime(), this.renewalTime(), this.evictionTime(), this.ttl());
    }

    public int hashCode() {
        return this.data() == null ? 0 : this.data().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Lease other = (Lease)obj;
        if (this.data() == other.data()) {
            return true;
        }
        if (this.data() == null || other.data() == null) {
            return false;
        }
        return this.data().equals(other.data());
    }

    protected boolean tryLock() {
        return this._lock.tryLock();
    }

    protected void releaseLock() {
        this._lock.unlock();
    }
}

