/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.lease;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.lease.Lease;
import org.mydotey.artemis.lease.LeaseCleanEventListener;
import org.mydotey.artemis.lease.LeaseUpdateSafeChecker;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.java.ObjectExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseManager<T> {
    private static final Logger _logger = LoggerFactory.getLogger(LeaseManager.class);
    private String _managerId;
    private ConcurrentHashMap<T, Lease<T>> _leaseCache;
    private Property<String, Integer> _dataInitCapacityProperty;
    private Property<String, Integer> _leaseTtlProperty;
    private Property<String, Integer> _cleanTaskThreadCountProperty;
    private Property<String, Integer> _cleanTaskInitDelayProperty;
    private Property<String, Integer> _cleanTaskRunIntervalProperty;
    private ScheduledExecutorService _cleanTaskExecutorService;
    private LeaseUpdateSafeChecker _leaseUpdateSafeChecker;
    private List<LeaseCleanEventListener<T>> _leaseCleanEventListeners = new ArrayList<LeaseCleanEventListener<T>>();

    public LeaseManager(String managerId) {
        ObjectExtension.requireNonBlank((String)managerId, (String)"managerId");
        this._managerId = managerId;
        this.initConfig();
        this._leaseCache = new ConcurrentHashMap((Integer)this._dataInitCapacityProperty.getValue(), 0.9f);
        this.scheduleCleanTask();
        this._leaseUpdateSafeChecker = new LeaseUpdateSafeChecker(this);
        _logger.info("LeaseManager '" + managerId + "' is inited.");
    }

    public String managerId() {
        return this._managerId;
    }

    public LeaseUpdateSafeChecker leaseUpdateSafeChecker() {
        return this._leaseUpdateSafeChecker;
    }

    public synchronized void addLeaseCleanEventListener(LeaseCleanEventListener<T> listener) {
        ObjectExtension.requireNonNull(listener, (String)"listener");
        this._leaseCleanEventListeners.add(listener);
    }

    public Lease<T> register(T data) {
        ObjectExtension.requireNonNull(data, (String)"data");
        Lease<T> lease = new Lease<T>(this, data, this._leaseTtlProperty);
        this._leaseCache.put(data, lease);
        return lease;
    }

    public Lease<T> get(T data) {
        ObjectExtension.requireNonNull(data, (String)"data");
        return this._leaseCache.get(data);
    }

    public boolean hasLeaseOf(T data) {
        Lease<T> lease = this.get(data);
        return lease != null && !lease.isEvicted();
    }

    protected void initConfig() {
        this._dataInitCapacityProperty = ArtemisConfig.properties().getIntProperty((Object)(this._managerId + ".lease-manager.data.init-capacity"), Integer.valueOf(50000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(10000), (Comparable)Integer.valueOf(1000000)));
        this._cleanTaskThreadCountProperty = ArtemisConfig.properties().getIntProperty((Object)(this._managerId + ".lease-manager.clean-task.thread-count"), Integer.valueOf(2), (Function)new RangeValueFilter((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(10)));
        this._cleanTaskInitDelayProperty = ArtemisConfig.properties().getIntProperty((Object)(this._managerId + ".lease-manager.clean-task.init-delay"), Integer.valueOf(1000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10000)));
        this._cleanTaskRunIntervalProperty = ArtemisConfig.properties().getIntProperty((Object)(this._managerId + ".lease-manager.clean-task.run-interval"), Integer.valueOf(1000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(5000)));
        this._leaseTtlProperty = ArtemisConfig.properties().getIntProperty((Object)(this._managerId + ".lease-manager.lease.ttl"), Integer.valueOf(20000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(10000), (Comparable)Integer.valueOf(604800000)));
    }

    private void scheduleCleanTask() {
        this._cleanTaskExecutorService = Executors.newScheduledThreadPool((Integer)this._cleanTaskThreadCountProperty.getValue(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.threadNameFormat()).build());
        this._cleanTaskExecutorService.scheduleAtFixedRate(new Runnable(){
            private String _traceKey;
            {
                this._traceKey = LeaseManager.this.managerId() + ".lease-manager.clean";
            }

            @Override
            public void run() {
                try {
                    ArtemisTraceExecutor.INSTANCE.execute(this._traceKey, () -> LeaseManager.this.clean());
                }
                catch (Throwable ex) {
                    _logger.error("Clean leases failed", ex);
                }
            }
        }, ((Integer)this._cleanTaskInitDelayProperty.getValue()).intValue(), ((Integer)this._cleanTaskRunIntervalProperty.getValue()).intValue(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        ArrayList cleaned = new ArrayList();
        for (Lease<T> lease : this._leaseCache.values()) {
            if (!lease.tryLock()) continue;
            try {
                Lease<T> value;
                if (!lease.isEvicted() && (!this._leaseUpdateSafeChecker.isSafe() || !lease.isExpired()) || (value = this._leaseCache.remove(lease.data())) == null) continue;
                if (value.creationTime() > lease.creationTime()) {
                    this._leaseCache.putIfAbsent(lease.data(), value);
                    continue;
                }
                cleaned.add(lease);
            }
            finally {
                lease.releaseLock();
            }
        }
        if (cleaned.isEmpty()) {
            return;
        }
        for (LeaseCleanEventListener leaseCleanEventListener : this._leaseCleanEventListeners) {
            leaseCleanEventListener.onClean(cleaned);
        }
        _logger.info("{} leases were cleaned.", (Object)cleaned.size());
    }

    protected String threadNameFormat() {
        return this._managerId + ".lease-manager.%d";
    }
}

