/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.lease;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.lease.LeaseManager;
import org.mydotey.artemis.metric.ArtemisMetricManagers;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.caravan.util.metric.EventMetric;
import org.mydotey.caravan.util.metric.MetricConfig;
import org.mydotey.java.ObjectExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueConfig;
import org.mydotey.scf.filter.RangeValueFilter;
import org.mydotey.util.CounterBuffer;
import org.mydotey.util.TimeSequenceCircularBufferConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseUpdateSafeChecker {
    private static final Logger _logger = LoggerFactory.getLogger(LeaseUpdateSafeChecker.class);
    private static final String LEASE_UPDATE_IDENTITY = "lease_update";
    private Property<String, Boolean> _enabledProperty;
    private Property<String, Integer> _timeWindowProperty;
    private Property<String, Integer> _percentageThresholdProperty;
    private Property<String, Integer> _maxCountThresholdProperty;
    private Property<String, Integer> _maxCountResetIntervalProperty;
    private volatile CounterBuffer<String> _counterBuffer;
    private volatile long _maxCount;
    private volatile long _maxCountLastUpdateTime;
    private volatile boolean _isSafe = true;
    private DynamicScheduledThread _safeCheckThread;
    private EventMetric _eventMetric;
    private LeaseManager<?> _leaseManager;
    private String _safeCheckerId;
    private Function<Integer, Integer> _timeWindowFilter = value -> {
        if (value == null || value < 10000) {
            return 10000;
        }
        if (value > 300000) {
            return 300000;
        }
        int m = value % 1000;
        if (m != 0) {
            value = value - m;
        }
        return value;
    };

    public LeaseUpdateSafeChecker(LeaseManager<?> leaseManager) {
        ObjectExtension.requireNonNull(leaseManager, (String)"leaseManager");
        this._leaseManager = leaseManager;
        this._safeCheckerId = this._leaseManager.managerId() + ".lease-manager.lease-update-safe-checker";
        ImmutableMap metadata = ImmutableMap.of((Object)"distribution", (Object)(this._safeCheckerId + ".event.distribution"));
        this._eventMetric = ArtemisMetricManagers.DEFAULT.eventMetricManager().getMetric(this._safeCheckerId + ".event", new MetricConfig((Map)metadata));
        this.initConfig();
        this.scheduleCheckTask();
    }

    public long maxCount() {
        return this._maxCount;
    }

    public long maxCountLastUpdateTime() {
        return this._maxCountLastUpdateTime;
    }

    public long countLastTimeWindow() {
        return this._counterBuffer.get((Object)LEASE_UPDATE_IDENTITY);
    }

    public boolean isSafe() {
        return this._isSafe || !this.isEnabled();
    }

    public boolean isEnabled() {
        return (Boolean)this._enabledProperty.getValue();
    }

    protected void markUpdate() {
        this._counterBuffer.increment((Object)LEASE_UPDATE_IDENTITY);
    }

    private void initConfig() {
        this._enabledProperty = ArtemisConfig.properties().getBooleanProperty((Object)(this._safeCheckerId + ".enabled"), Boolean.valueOf(true));
        this._timeWindowProperty = ArtemisConfig.properties().getIntProperty((Object)(this._safeCheckerId + ".time-window"), Integer.valueOf(10000), this._timeWindowFilter);
        this._percentageThresholdProperty = ArtemisConfig.properties().getIntProperty((Object)(this._safeCheckerId + ".percentage-threshold"), Integer.valueOf(85), (Function)new RangeValueFilter((Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)));
        this._maxCountThresholdProperty = ArtemisConfig.properties().getIntProperty((Object)(this._safeCheckerId + ".max-count-threshold"), Integer.valueOf(50), (Function)new RangeValueFilter((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1000000)));
        this._maxCountResetIntervalProperty = ArtemisConfig.properties().getIntProperty((Object)(this._safeCheckerId + ".max-count-reset-interval"), Integer.valueOf(600000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(60000), (Comparable)Integer.valueOf(86400000)));
        this._timeWindowProperty.addChangeListener(event -> this.resetLeaseUpdateCounterBuffer());
        this._enabledProperty.addChangeListener(event -> this.resetMaxCount());
    }

    private void scheduleCheckTask() {
        this.resetLeaseUpdateCounterBuffer();
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(ArtemisConfig.properties(), new RangeValueConfig((Comparable)Integer.valueOf(1000), (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(60000)), new RangeValueConfig((Comparable)Integer.valueOf(1000), (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(60000)));
        this._safeCheckThread = new DynamicScheduledThread(this._safeCheckerId, new Runnable(){

            @Override
            public void run() {
                try {
                    LeaseUpdateSafeChecker.this.safeCheck();
                }
                catch (Throwable ex) {
                    _logger.error("safe check failed.", ex);
                }
            }
        }, dynamicScheduledThreadConfig);
        this._safeCheckThread.setDaemon(true);
        this._safeCheckThread.start();
    }

    private void resetLeaseUpdateCounterBuffer() {
        int timeWindow = (Integer)this._timeWindowProperty.getValue();
        this._counterBuffer = new CounterBuffer(((TimeSequenceCircularBufferConfig.Builder)((TimeSequenceCircularBufferConfig.Builder)new TimeSequenceCircularBufferConfig.Builder().setTimeWindow((long)timeWindow)).setBucketTtl(1000L)).build());
        this.resetMaxCount();
        _logger.info("counterBuffer updated. TimeWindow: " + timeWindow);
    }

    private void safeCheck() {
        long maxCount;
        long leaseUpdateCountLastTimeWindow = this.countLastTimeWindow();
        if (leaseUpdateCountLastTimeWindow > (maxCount = this._maxCount)) {
            this.updateMaxCount(leaseUpdateCountLastTimeWindow);
            return;
        }
        if (maxCount < (long)((Integer)this._maxCountThresholdProperty.getValue()).intValue()) {
            return;
        }
        if (maxCount <= 0L) {
            return;
        }
        long percentage = leaseUpdateCountLastTimeWindow * 100L / maxCount;
        if (percentage < (long)((Integer)this._percentageThresholdProperty.getValue()).intValue()) {
            this._isSafe = false;
            this._eventMetric.addEvent("unsafe");
            String errorMessage = "Lease update count is too low! Maybe something bad happen! Renewal pencentage is: " + percentage;
            if (((Boolean)this._enabledProperty.getValue()).booleanValue()) {
                _logger.error(errorMessage);
            } else {
                _logger.warn(errorMessage);
            }
            return;
        }
        this._isSafe = true;
        this._eventMetric.addEvent("safe");
        if (System.currentTimeMillis() - this._maxCountLastUpdateTime > (long)((Integer)this._maxCountResetIntervalProperty.getValue()).intValue()) {
            _logger.warn("Lease Manager lease update max count is changed from {} to {} for {} ms update", new Object[]{this._maxCount, leaseUpdateCountLastTimeWindow, (int)((Integer)this._maxCountResetIntervalProperty.getValue())});
            this.updateMaxCount(leaseUpdateCountLastTimeWindow);
        }
    }

    private void resetMaxCount() {
        this.updateMaxCount(0L);
    }

    private void updateMaxCount(long maxCount) {
        _logger.info("Lease Manager lease update max count is changed from {} to {}", (Object)this._maxCount, (Object)maxCount);
        this._maxCount = maxCount;
        this._maxCountLastUpdateTime = System.currentTimeMillis();
    }
}

