/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.metric;

import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.metric.ArtemisMetricManagersProvider;
import org.mydotey.artemis.metric.NullArtemisMetricManagersProvider;
import org.mydotey.caravan.util.metric.AuditMetricManager;
import org.mydotey.caravan.util.metric.EventMetricManager;
import org.mydotey.caravan.util.metric.StatusMetricManager;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;
import org.mydotey.scf.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisMetricManagers {
    private static final Logger _logger = LoggerFactory.getLogger(ArtemisMetricManagers.class);
    public static final ArtemisMetricManagers DEFAULT = ArtemisMetricManagers.createDefault();
    private ArtemisMetricManagersProvider _provider;

    private static ArtemisMetricManagers createDefault() {
        Property providerProperty = ArtemisConfig.properties().getStringProperty((Object)"artemis.metric.default.managers-provider");
        ArtemisMetricManagersProvider provider = null;
        String providerType = StringExtension.trim((String)((String)providerProperty.getValue()), (char[])new char[0]);
        if (!StringExtension.isBlank((String)providerType)) {
            try {
                Class<?> clazz = Class.forName(providerType);
                provider = (ArtemisMetricManagersProvider)clazz.newInstance();
            }
            catch (Throwable ex) {
                _logger.error("Init metric managers provider failed.", ex);
            }
        }
        if (provider == null) {
            provider = NullArtemisMetricManagersProvider.INSTANCE;
        }
        _logger.info("Inited defualt ArtemisMetricManagers with provider " + provider.getClass().getName());
        return new ArtemisMetricManagers(provider);
    }

    public ArtemisMetricManagers(ArtemisMetricManagersProvider provider) {
        ObjectExtension.requireNonNull((Object)provider, (String)"provider");
        this._provider = provider;
    }

    public EventMetricManager eventMetricManager() {
        return this._provider.getEventMetricManager();
    }

    public AuditMetricManager valueMetricManager() {
        return this._provider.getValueMetricManager();
    }

    public StatusMetricManager<Double> getStatusMetricManager() {
        return this._provider.getStatusMetricManager();
    }
}

