/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.taskdispatcher;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.metric.ArtemisMetricManagers;
import org.mydotey.artemis.taskdispatcher.Task;
import org.mydotey.artemis.taskdispatcher.TaskAcceptor;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.caravan.util.metric.AuditMetric;
import org.mydotey.caravan.util.metric.MetricConfig;
import org.mydotey.java.collection.CollectionExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueFilter;

class BatchingTaskAcceptor<T extends Task>
extends TaskAcceptor<T, List<T>> {
    private Property<String, Integer> _maxBatchingSizeProperty;
    private Property<String, Integer> _maxBatchingDelayProperty;
    private final AuditMetric _batchingSizeAuditMetric;
    private AtomicInteger _pendingTaskCount = new AtomicInteger();

    public BatchingTaskAcceptor(String dispatcherId) {
        super(dispatcherId);
        this._maxBatchingSizeProperty = ArtemisConfig.properties().getIntProperty((Object)(this._acceptorId + ".max-batching-size"), Integer.valueOf(250), (Function)new RangeValueFilter((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(10000)));
        this._maxBatchingDelayProperty = ArtemisConfig.properties().getIntProperty((Object)(this._acceptorId + ".max-batching-delay"), Integer.valueOf(2000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(1000), (Comparable)Integer.valueOf(10000)));
        String batchingSizeMetricName = this._acceptorId + ".batching-size.distribution";
        this._batchingSizeAuditMetric = ArtemisMetricManagers.DEFAULT.valueMetricManager().getMetric(batchingSizeMetricName, new MetricConfig((Map)ImmutableMap.of((Object)"distribution", (Object)batchingSizeMetricName)));
    }

    @Override
    protected boolean isEmptyWork(List<T> work) {
        return CollectionExtension.isEmpty(work);
    }

    @Override
    protected List<T> filterExpiredTask(List<T> work) {
        ArrayList<Task> result = new ArrayList<Task>();
        for (Task task : work) {
            if (this.isExpiredTask(task)) {
                ArtemisTraceExecutor.INSTANCE.markEvent(this._taskStatusEventType, "expired");
                this._taskStatusEventMetric.addEvent("expired");
                continue;
            }
            result.add(task);
            ArtemisTraceExecutor.INSTANCE.markEvent(this._taskStatusEventType, "normal");
            this._taskStatusEventMetric.addEvent("normal");
        }
        this._batchingSizeAuditMetric.addValue((double)result.size());
        return result;
    }

    @Override
    protected int getWorkSize(List<T> w) {
        return w.size();
    }

    @Override
    protected void assignWork() {
        while (this.hasEnoughTasks()) {
            if (this.isBufferFull()) {
                List tasks = (List)this._workQueue.poll();
                this._pendingTaskCount.addAndGet(-tasks.size());
                ArtemisTraceExecutor.INSTANCE.markEvent(this._workStatusEventType, "buffer-full-dropped");
                this._workStatusEventMetric.addEvent("buffer-full-dropped");
            }
            List<T> work = this.generateWork();
            this._workQueue.add(work);
            this._pendingTaskCount.addAndGet(work.size());
            ArtemisTraceExecutor.INSTANCE.markEvent(this._workStatusEventType, "normal");
            this._workStatusEventMetric.addEvent("normal");
        }
    }

    private boolean hasEnoughTasks() {
        if (this._processingOrder.size() >= (Integer)this._maxBatchingSizeProperty.getValue()) {
            return true;
        }
        if (this._processingOrder.isEmpty()) {
            return false;
        }
        String taskId = (String)this._processingOrder.peek();
        Task task = (Task)this._acceptedTasks.get(taskId);
        long delay = System.currentTimeMillis() - task.submitTime();
        return delay >= (long)((Integer)this._maxBatchingDelayProperty.getValue()).intValue();
    }

    private List<T> generateWork() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        while (tasks.size() < (Integer)this._maxBatchingSizeProperty.getValue() && !this._processingOrder.isEmpty()) {
            String taskId = (String)this._processingOrder.poll();
            Task task = (Task)this._acceptedTasks.remove(taskId);
            tasks.add(task);
        }
        return tasks;
    }
}

