/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.taskdispatcher;

import org.mydotey.artemis.taskdispatcher.Task;
import org.mydotey.artemis.taskdispatcher.TaskAcceptor;
import org.mydotey.artemis.taskdispatcher.TaskDispatcher;
import org.mydotey.artemis.taskdispatcher.TaskExecutor;
import org.mydotey.artemis.taskdispatcher.TaskProcessor;

class DefaultTaskDispatcher<T extends Task, W>
implements TaskDispatcher<T> {
    private TaskAcceptor<T, W> _acceptorExecutor;
    private TaskExecutor<T, W> _taskExecutor;

    public DefaultTaskDispatcher(String dispatcherId, TaskAcceptor<T, W> taskAccetor, TaskProcessor<T, W> taskProcessor) {
        this._acceptorExecutor = taskAccetor;
        this._taskExecutor = new TaskExecutor<T, W>(dispatcherId, taskAccetor, taskProcessor);
    }

    @Override
    public void process(T task) {
        this._acceptorExecutor.accept(task);
    }

    @Override
    public void shutdown() {
        this._acceptorExecutor.shutdown();
        this._taskExecutor.shutdown();
    }
}

