/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.util;

import org.mydotey.artemis.ErrorCodes;
import org.mydotey.artemis.ResponseStatus;

public final class ResponseStatusUtil {
    public static final ResponseStatus SUCCESS_STATUS = new ResponseStatus("success", "", "success");
    public static final ResponseStatus RATE_LIMITED_STATUS = ResponseStatusUtil.newFailStatus("Request is rate limited.", "rate-limited");

    public static ResponseStatus newFailStatus(String errorMessage, String errorCode) {
        return new ResponseStatus("fail", errorMessage, errorCode);
    }

    public static ResponseStatus newPartialFailStatus(String errorMessage) {
        return new ResponseStatus("partial_fail", errorMessage, "partial_fail");
    }

    public static boolean isSuccess(ResponseStatus status) {
        if (status == null) {
            return false;
        }
        return "success".equals(status.getStatus());
    }

    public static boolean isFail(ResponseStatus status) {
        if (status == null) {
            return false;
        }
        return "fail".equals(status.getStatus());
    }

    public static boolean isPartialFail(ResponseStatus status) {
        if (status == null) {
            return false;
        }
        return "partial_fail".equals(status.getStatus());
    }

    public static boolean isServiceDown(ResponseStatus status) {
        if (status == null) {
            return false;
        }
        return ResponseStatusUtil.isFail(status) && status.getErrorCode() != null && ErrorCodes.serviceDownErrorCodes().contains(status.getErrorCode());
    }

    public static boolean isRateLimited(ResponseStatus status) {
        if (status == null) {
            return false;
        }
        return ResponseStatusUtil.isFail(status) && "rate-limited".equals(status.getErrorCode());
    }

    public static boolean isRerunnable(ResponseStatus status) {
        if (status == null) {
            return false;
        }
        return ResponseStatusUtil.isFail(status) && ErrorCodes.rerunnableErrorCodes().contains(status.getErrorCode());
    }

    private ResponseStatusUtil() {
    }
}

