/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.RouteRule;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.ServiceGroup;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.util.ServiceGroupKeys;
import org.mydotey.artemis.util.ServiceGroups;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;

public class RouteRules {
    public static final String DEFAULT_ROUTE_RULE = "default-route-rule";
    public static final String CANARY_ROUTE_RULE = "canary-route-rule";
    public static final String DEFAULT_GROUP_KEY = "default-group-key";
    public static final String DEFAULT_ROUTE_STRATEGY = "weighted-round-robin";

    public static final List<RouteRule> newRouteRules(Service service) {
        ValueCheckers.notNull(service, "service");
        List<RouteRule> routeRules = RouteRules.filterRouteRules(service.getRouteRules());
        Map<String, Instance> groupKey2Instance = RouteRules.generateGroupKey2Instance(service.getInstances());
        Map<String, Instance> instanceId2Instance = RouteRules.generateInstanceId2Instance(service.getInstances(), service.getLogicInstances());
        ArrayList newRouteRules = Lists.newArrayList();
        HashSet routeRuleIds = Sets.newHashSet();
        for (RouteRule routeRule : routeRules) {
            ArrayList nonemptyServiceGroups = Lists.newArrayList();
            for (ServiceGroup serviceGroup : routeRule.getGroups()) {
                if (serviceGroup == null || StringExtension.isBlank((String)serviceGroup.getGroupKey())) continue;
                List<Instance> instances = RouteRules.generateGroupInstances(serviceGroup, instanceId2Instance, groupKey2Instance);
                if (RouteRules.isCanaryRouteRule(routeRule)) {
                    HashMap maps = Maps.newHashMap();
                    for (Instance instance : instances) {
                        maps.put(instance.getInstanceId(), instance);
                    }
                    for (Instance instance : RouteRules.filterInstances(serviceGroup.getInstances())) {
                        if (maps.containsKey(instance.getInstanceId())) continue;
                        instances.add(instance);
                    }
                }
                if (CollectionExtension.isEmpty(instances)) continue;
                ServiceGroup nonemptyServiceGroup = serviceGroup.clone();
                nonemptyServiceGroup.setWeight(ServiceGroups.fixWeight(nonemptyServiceGroup.getWeight()));
                nonemptyServiceGroup.setInstances(instances);
                nonemptyServiceGroups.add(nonemptyServiceGroup);
            }
            routeRuleIds.add(routeRule.getRouteId().toLowerCase());
            newRouteRules.add(new RouteRule(routeRule.getRouteId(), nonemptyServiceGroups, routeRule.getStrategy()));
        }
        if (!routeRuleIds.contains(DEFAULT_ROUTE_RULE)) {
            newRouteRules.add(RouteRules.newDefaultRouteRule(Lists.newArrayList(groupKey2Instance.values())));
        }
        return newRouteRules;
    }

    public static List<Instance> generateGroupInstances(ServiceGroup serviceGroup, Map<String, Instance> instanceId2Instance, Map<String, Instance> groupKey2Instance) {
        Instance currentInstance;
        String groupKey = StringExtension.toLowerCase((String)serviceGroup.getGroupKey());
        HashMap instances = Maps.newHashMap();
        if (!CollectionExtension.isEmpty(serviceGroup.getInstanceIds())) {
            for (String instanceId : serviceGroup.getInstanceIds()) {
                if (StringExtension.isBlank((String)instanceId) || (currentInstance = instanceId2Instance.get(instanceId)) == null) continue;
                instances.put(instanceId, currentInstance);
            }
        }
        if (!StringExtension.isBlank((String)groupKey)) {
            for (String key : groupKey2Instance.keySet()) {
                if (!key.startsWith(groupKey + "/")) continue;
                currentInstance = groupKey2Instance.get(key);
                instances.put(currentInstance.getInstanceId(), currentInstance);
            }
        }
        return Lists.newArrayList(instances.values());
    }

    protected static List<RouteRule> filterRouteRules(List<RouteRule> routeRules) {
        ArrayList filterRouteRules = Lists.newArrayList();
        if (CollectionExtension.isEmpty(routeRules)) {
            return filterRouteRules;
        }
        for (RouteRule routeRule : routeRules) {
            if (routeRule == null || StringExtension.isBlank((String)routeRule.getRouteId()) || CollectionExtension.isEmpty(routeRule.getGroups())) continue;
            filterRouteRules.add(routeRule);
        }
        return filterRouteRules;
    }

    public static List<Instance> filterInstances(List<Instance> instances) {
        ArrayList filterInstances = Lists.newArrayList();
        if (CollectionExtension.isEmpty(instances)) {
            return filterInstances;
        }
        for (Instance instance : instances) {
            if (instance == null || StringExtension.isBlank((String)instance.getInstanceId())) continue;
            filterInstances.add(instance);
        }
        return filterInstances;
    }

    public static Map<String, Instance> generateGroupKey2Instance(List<Instance> instances) {
        HashMap groupInstances = Maps.newHashMap();
        for (Instance instance : RouteRules.filterInstances(instances)) {
            groupInstances.put(ServiceGroupKeys.of(instance).getGroupKey(), instance);
        }
        return groupInstances;
    }

    public static Map<String, Instance> generateInstanceId2Instance(List<Instance> instances, List<Instance> logicInstances) {
        HashMap groupInstances = Maps.newHashMap();
        for (Instance instance : RouteRules.filterInstances(logicInstances)) {
            groupInstances.put(instance.getInstanceId(), instance);
        }
        for (Instance instance : RouteRules.filterInstances(instances)) {
            groupInstances.put(instance.getInstanceId(), instance);
        }
        return groupInstances;
    }

    public static RouteRule newDefaultRouteRule(List<Instance> instances) {
        RouteRule routeRule = new RouteRule(DEFAULT_ROUTE_RULE, Lists.newArrayList((Object[])new ServiceGroup[]{new ServiceGroup(DEFAULT_GROUP_KEY, ServiceGroups.fixWeight(null), instances, null)}), DEFAULT_ROUTE_STRATEGY);
        return routeRule;
    }

    public static boolean isDefaultRouteRule(RouteRule routeRule) {
        ValueCheckers.notNull(routeRule, "routeRule");
        return Objects.equals(DEFAULT_ROUTE_RULE, routeRule.getRouteId().toLowerCase());
    }

    public static boolean isCanaryRouteRule(RouteRule routeRule) {
        ValueCheckers.notNull(routeRule, "routeRule");
        return Objects.equals(CANARY_ROUTE_RULE, routeRule.getRouteId().toLowerCase());
    }
}

