/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.util;

import org.mydotey.artemis.Region;
import org.mydotey.artemis.checker.ValueChecker;
import org.mydotey.artemis.config.DeploymentConfig;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;

public class SameRegionChecker
implements ValueChecker<Region> {
    public static final SameRegionChecker DEFAULT = new SameRegionChecker();

    @Override
    public void check(String regionId, String valueName) {
        if (!this.isSameRegion(regionId)) {
            throw new IllegalArgumentException(valueName + " is not the current region. expected: " + DeploymentConfig.regionId() + ", actual: " + regionId);
        }
    }

    @Override
    public void check(Region value, String valueName) {
        ObjectExtension.requireNonNull((Object)value, (String)valueName);
        this.check(value.getRegionId(), valueName);
    }

    public boolean isSameRegion(String regionId) {
        if (StringExtension.isBlank((String)regionId)) {
            return false;
        }
        return regionId.equalsIgnoreCase(DeploymentConfig.regionId());
    }
}

