/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.java.collection.CollectionExtension;

public class SearchTree<K, V> {
    private final Map<K, SearchTree<K, V>> children = Maps.newHashMap();
    private V value;
    private V defaultChildrenValue;

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public V getDefaultChildrenValue() {
        return this.defaultChildrenValue;
    }

    public void setDefaultChildrenValue(V defaultChildrenValue) {
        this.defaultChildrenValue = defaultChildrenValue;
    }

    public V get(List<K> cascadingFactors) {
        if (CollectionExtension.isEmpty(cascadingFactors)) {
            return this.value;
        }
        ArrayList factors = Lists.newArrayList(cascadingFactors);
        SearchTree<K, V> g = this.children.get(factors.remove(0));
        if (g == null) {
            return this.defaultChildrenValue;
        }
        return g.get(factors);
    }

    public V first(List<K> cascadingFactors) {
        if (this.value != null || CollectionExtension.isEmpty(cascadingFactors)) {
            return this.value;
        }
        ArrayList factors = Lists.newArrayList(cascadingFactors);
        SearchTree<K, V> g = this.children.get(factors.remove(0));
        if (g == null) {
            return this.defaultChildrenValue;
        }
        return g.first(factors);
    }

    public void add(List<K> cascadingFactors, V value) {
        if (CollectionExtension.isEmpty(cascadingFactors)) {
            this.value = value;
            return;
        }
        ArrayList factors = Lists.newArrayList(cascadingFactors);
        Object factor = factors.remove(0);
        ValueCheckers.notNull(factor, "factor");
        SearchTree<K, V> child = this.children.get(factor);
        if (child == null) {
            child = new SearchTree<K, V>();
            this.children.put(factor, child);
        }
        child.add(factors, value);
    }

    public void put(K childKey, SearchTree<K, V> searchTree) {
        ValueCheckers.notNull(childKey, "childKey");
        ValueCheckers.notNull(searchTree, "searchTree");
        this.children.put(childKey, searchTree);
    }
}

