/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.util;

import java.util.List;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.ServiceGroup;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.util.SameRegionChecker;
import org.mydotey.artemis.util.SameZoneChecker;
import org.mydotey.artemis.util.ServiceGroupKeys;
import org.mydotey.java.StringExtension;

public final class ServiceGroups {
    public static final String DEFAULT_GROUP_ID = "default";
    public static final int MAX_WEIGHT_VALUE = 10000;
    public static final int MIN_WEIGHT_VALUE = 0;
    public static final int DEFAULT_WEIGHT_VALUE = 5;

    private ServiceGroups() {
    }

    public static int fixWeight(Integer weight) {
        if (weight == null || weight < 0) {
            return 5;
        }
        if (weight > 10000) {
            return 10000;
        }
        return weight;
    }

    public static boolean isDefaultGroupId(String groupId) {
        if (StringExtension.isBlank((String)groupId)) {
            return true;
        }
        return DEFAULT_GROUP_ID.equalsIgnoreCase(groupId.trim());
    }

    public static boolean isGroupCanaryInstance(String groupKey, Instance instance) {
        if (StringExtension.isBlank((String)groupKey) || instance == null) {
            return false;
        }
        return "default-group-key".equalsIgnoreCase(groupKey.trim()) || ServiceGroupKeys.of(instance).getGroupKey().startsWith(groupKey);
    }

    public static boolean isLocalZone(ServiceGroup serviceGroup) {
        ValueCheckers.notNull(serviceGroup, "serviceGroup");
        if (StringExtension.isBlank((String)serviceGroup.getGroupKey())) {
            return true;
        }
        List<String> keys = ServiceGroupKeys.toGroupIdList(serviceGroup.getGroupKey());
        if (keys.size() >= 3) {
            String regionId = keys.get(1);
            String zoneId = keys.get(2);
            return SameRegionChecker.DEFAULT.isSameRegion(regionId) && SameZoneChecker.DEFAULT.isSameZone(zoneId);
        }
        return true;
    }
}

