/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import java.util.List;
import java.util.Map;
import org.mydotey.artemis.RouteRule;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.ServiceGroup;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.artemis.discovery.DiscoveryFilter;
import org.mydotey.artemis.management.GroupRepository;
import org.mydotey.artemis.util.RouteRules;
import org.mydotey.java.collection.CollectionExtension;

public class GroupDiscoveryFilter
implements DiscoveryFilter {
    private static volatile GroupDiscoveryFilter instance;
    private final GroupRepository groupRepository = GroupRepository.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupDiscoveryFilter getInstance() {
        if (instance != null) return instance;
        Class<GroupDiscoveryFilter> clazz = GroupDiscoveryFilter.class;
        synchronized (GroupDiscoveryFilter.class) {
            if (instance != null) return instance;
            instance = new GroupDiscoveryFilter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void filter(Service service, DiscoveryConfig discoveryConfig) {
        if (service == null || discoveryConfig == null) {
            return;
        }
        service.setLogicInstances(this.groupRepository.getServiceInstances(service.getServiceId()));
        List<RouteRule> routeRules = this.groupRepository.getServiceRouteRules(service.getServiceId(), discoveryConfig.getRegionId());
        if (!CollectionExtension.isEmpty(routeRules)) {
            for (RouteRule routeRule : routeRules) {
                if (routeRule == null || !RouteRules.isCanaryRouteRule((RouteRule)routeRule)) continue;
                Map groupKey2Instance = RouteRules.generateGroupKey2Instance((List)service.getInstances());
                Map instanceId2Instance = RouteRules.generateInstanceId2Instance((List)service.getInstances(), (List)service.getLogicInstances());
                for (ServiceGroup serviceGroup : routeRule.getGroups()) {
                    serviceGroup.setInstances(RouteRules.generateGroupInstances((ServiceGroup)serviceGroup, (Map)instanceId2Instance, (Map)groupKey2Instance));
                }
            }
        }
        service.setRouteRules(routeRules);
    }
}

