/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.InstanceKey;
import org.mydotey.artemis.RouteRule;
import org.mydotey.artemis.ServiceGroup;
import org.mydotey.artemis.ServiceGroupKey;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.management.common.OperationContext;
import org.mydotey.artemis.management.group.Group;
import org.mydotey.artemis.management.group.GroupInstance;
import org.mydotey.artemis.management.group.GroupOperations;
import org.mydotey.artemis.management.group.GroupTags;
import org.mydotey.artemis.management.group.RouteRuleGroup;
import org.mydotey.artemis.management.group.RouteRuleInfo;
import org.mydotey.artemis.management.group.ServiceInstance;
import org.mydotey.artemis.management.group.ServiceRouteRule;
import org.mydotey.artemis.management.group.dao.BusinessDao;
import org.mydotey.artemis.management.group.dao.GroupDao;
import org.mydotey.artemis.management.group.dao.GroupInstanceDao;
import org.mydotey.artemis.management.group.dao.GroupOperationDao;
import org.mydotey.artemis.management.group.dao.GroupTagDao;
import org.mydotey.artemis.management.group.dao.RouteRuleDao;
import org.mydotey.artemis.management.group.dao.RouteRuleGroupDao;
import org.mydotey.artemis.management.group.dao.ServiceInstanceDao;
import org.mydotey.artemis.management.group.model.GroupInstanceModel;
import org.mydotey.artemis.management.group.model.GroupModel;
import org.mydotey.artemis.management.group.model.GroupOperationModel;
import org.mydotey.artemis.management.group.model.GroupTagModel;
import org.mydotey.artemis.management.group.model.RouteRuleGroupModel;
import org.mydotey.artemis.management.group.model.RouteRuleModel;
import org.mydotey.artemis.management.group.model.ServiceInstanceModel;
import org.mydotey.artemis.management.group.util.GroupInstances;
import org.mydotey.artemis.management.group.util.Groups;
import org.mydotey.artemis.management.group.util.RouteRuleGroups;
import org.mydotey.artemis.management.group.util.ServiceInstances;
import org.mydotey.artemis.management.group.util.ServiceRouteRules;
import org.mydotey.artemis.registry.RegistryRepository;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.InstanceChanges;
import org.mydotey.artemis.util.SearchTree;
import org.mydotey.artemis.util.ServiceGroupKeys;
import org.mydotey.artemis.util.ServiceGroups;
import org.mydotey.artemis.util.StringUtil;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.mydotey.java.ThreadExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueConfig;
import org.mydotey.scf.filter.RangeValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupRepository {
    private static final Logger logger = LoggerFactory.getLogger(GroupRepository.class);
    private static volatile GroupRepository instance;
    private final RouteRuleDao routeRuleDao = RouteRuleDao.INSTANCE;
    private final RouteRuleGroupDao routeRuleGroupDao = RouteRuleGroupDao.INSTANCE;
    private final GroupDao groupDao = GroupDao.INSTANCE;
    private final GroupOperationDao groupOperationDao = GroupOperationDao.INSTANCE;
    private final GroupTagDao groupTagDao = GroupTagDao.INSTANCE;
    private final GroupInstanceDao groupInstanceDao = GroupInstanceDao.INSTANCE;
    private final BusinessDao businessDao = BusinessDao.INSTANCE;
    private final ServiceInstanceDao serviceInstanceDao = ServiceInstanceDao.INSTANCE;
    private final RegistryRepository registryRepository = RegistryRepository.getInstance();
    private DynamicScheduledThread cacheRefresher;
    private final Property<String, Integer> managementDBSyncWaitTimeProperty = ArtemisConfig.properties().getIntProperty((Object)"artemis.management.db-sync.wait-time", Integer.valueOf(2000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(60000)));
    private volatile long lastRefreshTime;
    private volatile boolean lastRefreshSuccess;
    private volatile ListMultimap<String, RouteRule> routeRules = ArrayListMultimap.create();
    private volatile Map<Long, ServiceRouteRule> serviceRouteRules = Maps.newHashMap();
    private volatile Map<Long, RouteRuleGroup> serviceRouteRuleGroups = Maps.newHashMap();
    private volatile Map<Long, Group> serviceGroups = Maps.newHashMap();
    private volatile Map<Long, GroupOperations> serviceGroupOperations = Maps.newHashMap();
    private volatile Map<Long, GroupTags> serviceGroupTags = Maps.newHashMap();
    private volatile ListMultimap<String, Instance> serviceInstances = ArrayListMultimap.create();
    private volatile ListMultimap<String, ServiceGroup> serviceInstanceGroups = ArrayListMultimap.create();
    private volatile SearchTree<String, GroupOperations> operationsSearchTree = new SearchTree();
    private AtomicBoolean _inited = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupRepository getInstance() {
        if (instance != null) return instance;
        Class<GroupRepository> clazz = GroupRepository.class;
        synchronized (GroupRepository.class) {
            if (instance != null) return instance;
            instance = new GroupRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GroupRepository() {
    }

    public void init() {
        if (!this._inited.compareAndSet(false, true)) {
            return;
        }
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(ArtemisConfig.properties(), new RangeValueConfig((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10000)), new RangeValueConfig((Comparable)Integer.valueOf(5000), (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(60000)));
        String cacheRefreshKey = "artemis.management.group.data.cache-refresher";
        this.cacheRefresher = new DynamicScheduledThread("artemis.management.group.data.cache-refresher", new Runnable(){

            @Override
            public void run() {
                GroupRepository.this.lastRefreshTime = System.currentTimeMillis();
                GroupRepository.this.lastRefreshSuccess = (Boolean)ArtemisTraceExecutor.INSTANCE.execute("artemis.management.group.data.cache-refresher", () -> GroupRepository.this.refreshCache());
            }
        }, dynamicScheduledThreadConfig);
        this.cacheRefresher.setDaemon(true);
        this.cacheRefresher.start();
    }

    public boolean isInstanceDown(Instance instance) {
        return this.operationsSearchTree.first(ServiceGroupKeys.toGroupIdList((ServiceGroupKey)ServiceGroupKeys.of((Instance)instance))) != null;
    }

    public List<RouteRule> getServiceRouteRules(String serviceId, String regionId) {
        return this.getServiceRouteRules(serviceId);
    }

    public List<RouteRule> getServiceRouteRules(String serviceId) {
        if (StringExtension.isBlank((String)serviceId)) {
            return Lists.newArrayList();
        }
        return this.routeRules.get((Object)serviceId);
    }

    public List<ServiceRouteRule> getAllRouteRules(String regionId) {
        return Lists.newArrayList(this.serviceRouteRules.values());
    }

    public List<Instance> getServiceInstances(String serviceId) {
        if (StringExtension.isBlank((String)serviceId)) {
            return Lists.newArrayList();
        }
        return this.serviceInstances.get((Object)serviceId);
    }

    public Map<InstanceKey, Instance> getLogicalInstances() {
        HashMap instances = Maps.newHashMap();
        for (Instance instance : this.serviceInstances.values()) {
            instances.put(InstanceKey.of((Instance)instance), instance);
        }
        return instances;
    }

    public List<ServiceGroup> getServiceInstanceGroups(String serviceId) {
        if (StringExtension.isBlank((String)serviceId)) {
            return Lists.newArrayList();
        }
        return this.serviceInstanceGroups.get((Object)serviceId);
    }

    public List<ServiceRouteRule> getRouteRules(RouteRuleModel filter) {
        return ServiceRouteRules.newServiceRouteRules(this.routeRuleDao.select(filter));
    }

    public void insertRouteRules(OperationContext operationContext, List<RouteRuleModel> models) {
        this.businessDao.insertOrUpdateRouteRules(operationContext, models);
    }

    public void updateRouteRules(OperationContext operationContext, List<RouteRuleModel> models) {
        this.businessDao.insertOrUpdateRouteRules(operationContext, models);
    }

    public void deleteRouteRules(OperationContext operationContext, List<Long> routeRuleIds) {
        this.businessDao.deleteRouteRules(operationContext, routeRuleIds);
    }

    public List<RouteRuleGroup> getAllRouteRuleGroups(String regionId) {
        return Lists.newArrayList(this.serviceRouteRuleGroups.values());
    }

    public List<RouteRuleGroup> getRouteRuleGroups(RouteRuleGroupModel filter) {
        return RouteRuleGroups.newRouteRuleGroups(this.routeRuleGroupDao.select(filter));
    }

    public void insertServiceRouteRuleGroups(OperationContext operationContext, List<RouteRuleGroupModel> models) {
        this.businessDao.insertOrUpdateRouteRuleGroups(operationContext, models);
    }

    public void updateServiceRouteRuleGroups(OperationContext operationContext, List<RouteRuleGroupModel> models) {
        this.businessDao.insertOrUpdateRouteRuleGroups(operationContext, models);
    }

    public void deleteServiceRouteRuleGroups(OperationContext operationContext, List<Long> routeRuleGroupIds) {
        this.businessDao.deleteRouteRuleGroups(operationContext, routeRuleGroupIds);
    }

    public void releaseServiceRouteRuleGroups(OperationContext operationContext, List<RouteRuleGroupModel> models) {
        this.businessDao.releaseRouteRuleGroups(operationContext, models);
    }

    public void publishServiceRouteRuleGroups(OperationContext operationContext, List<RouteRuleGroupModel> models) {
        this.businessDao.publishRouteRuleGroups(operationContext, models);
    }

    public List<Group> getAllGroups(String regionId) {
        return Lists.newArrayList(this.serviceGroups.values());
    }

    public List<Group> getGroups(GroupModel filter) {
        return Groups.newGroups(this.groupDao.select(filter));
    }

    public void insertGroups(OperationContext operationContext, List<GroupModel> groupModels) {
        this.businessDao.insertOrUpdateGroups(operationContext, groupModels);
    }

    public void updateGroups(OperationContext operationContext, List<GroupModel> groupModels) {
        this.businessDao.insertOrUpdateGroups(operationContext, groupModels);
    }

    public void deleteGroups(OperationContext operationContext, List<Long> groupIds) {
        this.businessDao.deleteGroups(operationContext, groupIds);
    }

    public List<GroupOperations> getAllGroupOperations(String regionId) {
        return Lists.newArrayList(this.serviceGroupOperations.values());
    }

    public GroupOperations getGroupOperations(Long groupId) {
        return this.serviceGroupOperations.get(groupId);
    }

    public void operateGroupOperations(OperationContext operationContext, List<GroupOperationModel> groupOperations, boolean isOperationComplete) {
        if (CollectionExtension.isEmpty(groupOperations)) {
            return;
        }
        if (isOperationComplete) {
            this.businessDao.deleteGroupOperation(operationContext, groupOperations);
        } else {
            this.businessDao.insertOrUpdateGroupOperation(operationContext, groupOperations);
        }
    }

    public List<GroupTags> getAllGroupTags(String regionId) {
        return Lists.newArrayList(this.serviceGroupTags.values());
    }

    public GroupTags getGroupTags(Long groupId) {
        return this.serviceGroupTags.get(groupId);
    }

    public void insertGroupTags(List<GroupTagModel> tags) {
        this.groupTagDao.insertOrUpdate(tags);
    }

    public void updateGroupTags(List<GroupTagModel> tags) {
        this.groupTagDao.insertOrUpdate(tags);
    }

    public void deleteGroupTags(GroupTagModel filter) {
        this.groupTagDao.delete(filter);
    }

    public void createRouteRules(OperationContext operationContext, String serviceId, List<RouteRuleInfo> routeRuleInfos) {
        this.businessDao.createServiceRouteRules(operationContext, serviceId, routeRuleInfos);
    }

    public void activateRouteRules(OperationContext operationContext, String serviceId, List<RouteRuleInfo> routeRuleInfos) {
        this.businessDao.activateServiceRouteRules(operationContext, serviceId, routeRuleInfos);
    }

    public void operateGroupOperation(OperationContext operationContext, GroupModel groupModel, boolean isOperationComplete) {
        this.businessDao.operationGroupOperation(operationContext, groupModel, isOperationComplete);
    }

    public List<GroupInstance> getGroupInstances(GroupInstanceModel filter) {
        return GroupInstances.newGroupInstances(this.groupInstanceDao.select(filter));
    }

    public void deleteGroupInstances(OperationContext operationContext, List<Long> groupInstanceIds) {
        this.businessDao.deleteGroupInstances(operationContext, groupInstanceIds);
    }

    public void deleteGroupInstancesByFilter(OperationContext operationContext, List<GroupInstanceModel> groupInstances) {
        this.businessDao.deleteGroupInstancesByFilter(operationContext, groupInstances);
    }

    public void insertGroupInstances(OperationContext operationContext, List<GroupInstanceModel> groupInstanceModels) {
        this.businessDao.insertGroupInstances(operationContext, groupInstanceModels);
    }

    public List<ServiceInstance> getServiceInstances(ServiceInstanceModel filter) {
        return ServiceInstances.newServiceInstances(this.serviceInstanceDao.select(filter));
    }

    public void insertServiceInstances(OperationContext operationContext, List<ServiceInstanceModel> serviceInstances) {
        this.businessDao.insertServiceInstances(operationContext, serviceInstances);
    }

    public void deleteServiceInstances(OperationContext operationContext, List<Long> serviceInstanceIds) {
        this.businessDao.deleteServiceInstances(operationContext, serviceInstanceIds);
    }

    public void deleteServiceInstancesByFilter(OperationContext operationContext, List<ServiceInstanceModel> serviceInstances) {
        this.businessDao.deleteServiceInstancesByFilter(operationContext, serviceInstances);
    }

    public Group generateGroup(GroupModel groupModel) {
        return Groups.newGroup(this.businessDao.generateGroup(groupModel));
    }

    public ServiceRouteRule generateRouteRule(RouteRuleModel routeRuleModel) {
        return ServiceRouteRules.newServiceRouteRule(this.businessDao.generateRouteRule(routeRuleModel));
    }

    public RouteRuleGroup generateRouteRuleGroup(RouteRuleGroupModel routeRuleGroupModel) {
        return RouteRuleGroups.newRouteRuleGroup(this.routeRuleGroupDao.generateGroup(routeRuleGroupModel));
    }

    public void updateGroupInstances(OperationContext operationContext, Long groupId, Set<String> instanceIds) {
        this.businessDao.updateGroupInstance(operationContext, groupId, instanceIds);
    }

    public boolean isLastRefreshSuccess() {
        return this.lastRefreshSuccess;
    }

    public long lastRefreshTime() {
        return this.lastRefreshTime;
    }

    public void waitForPeerSync() {
        ThreadExtension.sleep((int)((Integer)this.managementDBSyncWaitTimeProperty.getValue()));
    }

    protected boolean refreshCache() {
        Group group;
        Set<Long> changeGroups;
        Set<String> changedServices;
        try {
            changedServices = this.refreshServiceRouteRulesCache();
        }
        catch (Throwable ex) {
            logger.error("service route-rules cache refresh failed", ex);
            return false;
        }
        try {
            changedServices.addAll(this.refreshServiceInstancesCache());
        }
        catch (Throwable ex) {
            logger.error("service instances cache refresh failed", ex);
            return false;
        }
        try {
            changeGroups = this.refreshGroupOperationsCache();
        }
        catch (Throwable ex) {
            logger.error("group operations cache refresh failed", ex);
            return false;
        }
        SearchTree newOperationsSearchTree = new SearchTree();
        for (Long id : this.serviceGroupOperations.keySet()) {
            group = this.serviceGroups.get(id);
            if (group == null) continue;
            newOperationsSearchTree.add(ServiceGroupKeys.toGroupIdList((String)group.getGroupKey()), (Object)this.serviceGroupOperations.get(id));
        }
        this.operationsSearchTree = newOperationsSearchTree;
        for (Long groupId : changeGroups) {
            group = this.serviceGroups.get(groupId);
            if (group == null) continue;
            changedServices.add(group.getServiceId());
        }
        for (String serviceKey : changedServices) {
            this.registryRepository.addInstanceChange(InstanceChanges.newReloadInstanceChange((String)serviceKey));
        }
        return true;
    }

    protected Set<String> refreshServiceRouteRulesCache() {
        ArrayListMultimap newRouteRules = ArrayListMultimap.create();
        ArrayListMultimap newRouteRuleGroups = ArrayListMultimap.create();
        HashMap newServiceRouteRules = Maps.newHashMap();
        Map<Long, RouteRuleGroup> newServiceRouteRuleGroups = this.getRouteRuleGroups();
        Map<Long, Group> newServiceGroups = this.getServiceGroups();
        Map<Long, GroupTags> newServiceGroupTags = this.getServiceGroupTags();
        ListMultimap<Long, String> newGroupInstances = this.getServiceGroupInstances();
        ArrayListMultimap newServiceInstanceGroups = ArrayListMultimap.create();
        for (Group group : newServiceGroups.values()) {
            GroupTags tags = newServiceGroupTags.get(group.getGroupId());
            List instanceIds = newGroupInstances.get((Object)group.getGroupId());
            ServiceGroup serviceGroup = new ServiceGroup(group.getGroupKey(), null);
            if (tags != null) {
                serviceGroup.setMetadata(tags.getTags());
            }
            if (instanceIds != null) {
                serviceGroup.setInstanceIds(instanceIds);
            }
            newServiceInstanceGroups.put((Object)group.getServiceId(), (Object)serviceGroup);
        }
        for (RouteRuleGroup routeRuleGroup : newServiceRouteRuleGroups.values()) {
            newRouteRuleGroups.put((Object)routeRuleGroup.getRouteRuleId(), (Object)routeRuleGroup);
        }
        List<RouteRuleModel> models = this.routeRuleDao.query();
        for (RouteRuleModel model : models) {
            newServiceRouteRules.put(model.getId(), ServiceRouteRules.newServiceRouteRule(model));
            if (!"active".equalsIgnoreCase(model.getStatus())) continue;
            RouteRule routeRule = new RouteRule(model.getName(), model.getStrategy());
            ArrayList serviceGroups = Lists.newArrayList();
            routeRule.setGroups((List)serviceGroups);
            for (RouteRuleGroup routeRuleGroup : newRouteRuleGroups.get((Object)model.getId())) {
                Group group = newServiceGroups.get(routeRuleGroup.getGroupId());
                GroupTags tags = newServiceGroupTags.get(routeRuleGroup.getGroupId());
                List instanceIds = newGroupInstances.get((Object)routeRuleGroup.getGroupId());
                if (group == null || !"active".equalsIgnoreCase(group.getStatus())) continue;
                ServiceGroup serviceGroup = new ServiceGroup(group.getGroupKey(), Integer.valueOf(ServiceGroups.fixWeight((Integer)routeRuleGroup.getWeight())));
                if (tags != null) {
                    serviceGroup.setMetadata(tags.getTags());
                }
                if (instanceIds != null) {
                    serviceGroup.setInstanceIds(instanceIds);
                }
                serviceGroups.add(serviceGroup);
            }
            if (CollectionExtension.isEmpty((Collection)serviceGroups)) continue;
            newRouteRules.put((Object)model.getServiceId(), (Object)routeRule);
        }
        ListMultimap<String, RouteRule> listMultimap = this.routeRules;
        this.routeRules = newRouteRules;
        this.serviceRouteRules = newServiceRouteRules;
        this.serviceRouteRuleGroups = newServiceRouteRuleGroups;
        this.serviceGroups = newServiceGroups;
        this.serviceGroupTags = newServiceGroupTags;
        this.serviceInstanceGroups = newServiceInstanceGroups;
        return this.generateServiceChanges(this.routeRules, listMultimap);
    }

    protected Set<String> refreshServiceInstancesCache() {
        ListMultimap<String, Instance> newInstances = this.getServiceInstances();
        ListMultimap<String, Instance> oldInstances = this.serviceInstances;
        this.serviceInstances = newInstances;
        HashSet changeServices = Sets.newHashSet();
        for (String serviceId : newInstances.keySet()) {
            if (!oldInstances.containsKey((Object)serviceId)) {
                changeServices.add(serviceId);
            }
            Set<String> newInstanceIds = this.generateServiceInstanceIds(newInstances.get((Object)serviceId));
            Set<String> oldInstanceIds = this.generateServiceInstanceIds(oldInstances.get((Object)serviceId));
            if (newInstanceIds.size() == oldInstanceIds.size() && newInstanceIds.containsAll(oldInstanceIds)) continue;
            changeServices.add(serviceId);
        }
        for (String serviceId : oldInstances.keySet()) {
            if (newInstances.containsKey((Object)serviceId)) continue;
            changeServices.add(serviceId);
        }
        return changeServices;
    }

    protected Map<Long, RouteRuleGroup> getRouteRuleGroups() {
        HashMap newRouteRuleGroups = Maps.newHashMap();
        for (RouteRuleGroupModel model : this.routeRuleGroupDao.query()) {
            newRouteRuleGroups.put(model.getId(), RouteRuleGroups.newRouteRuleGroup(model));
        }
        return newRouteRuleGroups;
    }

    protected Map<Long, Group> getServiceGroups() {
        HashMap newServiceGroups = Maps.newHashMap();
        for (GroupModel model : this.groupDao.query()) {
            newServiceGroups.put(model.getId(), Groups.newGroup(model));
        }
        return newServiceGroups;
    }

    protected Map<Long, GroupTags> getServiceGroupTags() {
        HashMap newGroupTags = Maps.newHashMap();
        ArrayListMultimap m = ArrayListMultimap.create();
        for (GroupTagModel model : this.groupTagDao.query()) {
            m.put((Object)model.getGroupId(), (Object)model);
        }
        for (Long id : m.keySet()) {
            HashMap tags = Maps.newHashMap();
            for (GroupTagModel tag : m.get((Object)id)) {
                tags.put(tag.getTag(), tag.getValue());
            }
            newGroupTags.put(id, new GroupTags(id, tags));
        }
        return newGroupTags;
    }

    protected ListMultimap<Long, String> getServiceGroupInstances() {
        ArrayListMultimap newGroupInstances = ArrayListMultimap.create();
        for (GroupInstanceModel model : this.groupInstanceDao.query()) {
            newGroupInstances.put((Object)model.getGroupId(), (Object)model.getInstanceId());
        }
        return newGroupInstances;
    }

    protected ListMultimap<String, Instance> getServiceInstances() {
        ArrayListMultimap newServiceInstances = ArrayListMultimap.create();
        for (ServiceInstanceModel model : this.serviceInstanceDao.query()) {
            Instance instance = new Instance();
            instance.setServiceId(model.getServiceId());
            instance.setInstanceId(model.getInstanceId());
            instance.setIp(model.getIp());
            instance.setMachineName(model.getMachineName());
            instance.setPort(model.getPort());
            instance.setProtocol(model.getProtocol());
            instance.setHealthCheckUrl(model.getHealthCheckUrl());
            instance.setRegionId(model.getRegionId());
            instance.setZoneId(model.getZoneId());
            instance.setGroupId(model.getGroupId());
            Map metadata = Maps.newHashMap();
            if (!StringExtension.isBlank((String)model.getMetadata())) {
                try {
                    metadata = (Map)JacksonJsonCodec.DEFAULT.decode(model.getMetadata().getBytes(), Map.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            instance.setMetadata(metadata);
            instance.setStatus("up");
            instance.setUrl(model.getUrl());
            newServiceInstances.put((Object)instance.getServiceId(), (Object)instance);
        }
        return newServiceInstances;
    }

    protected Set<String> generateServiceChanges(ListMultimap<String, RouteRule> newValues, ListMultimap<String, RouteRule> oldValues) {
        HashSet changeServices = Sets.newHashSet();
        for (String serviceId : newValues.keySet()) {
            if (!oldValues.containsKey((Object)serviceId)) {
                changeServices.add(serviceId);
            }
            Set<String> newRouteRuleGroupKeys = this.generateRouteRuleGroupKeys(newValues.get((Object)serviceId));
            Set<String> oldRouteRuleGroupKeys = this.generateRouteRuleGroupKeys(oldValues.get((Object)serviceId));
            if (newRouteRuleGroupKeys.size() == oldRouteRuleGroupKeys.size() && newRouteRuleGroupKeys.containsAll(oldRouteRuleGroupKeys)) continue;
            changeServices.add(serviceId);
        }
        for (String serviceId : oldValues.keySet()) {
            if (newValues.containsKey((Object)serviceId)) continue;
            changeServices.add(serviceId);
        }
        return changeServices;
    }

    protected Set<String> generateRouteRuleGroupKeys(List<RouteRule> routeRules) {
        HashSet routeRuleGroupKeys = Sets.newHashSet();
        for (RouteRule routeRule : routeRules) {
            routeRuleGroupKeys.add(routeRule.getRouteId() + "/" + routeRule.getStrategy());
            for (ServiceGroup group : routeRule.getGroups()) {
                if (CollectionExtension.isEmpty((Collection)group.getInstanceIds())) {
                    routeRuleGroupKeys.add(routeRule.getRouteId() + "/" + group.getGroupKey() + "/" + group.getWeight());
                    continue;
                }
                for (String instanceId : group.getInstanceIds()) {
                    routeRuleGroupKeys.add(routeRule.getRouteId() + "/" + group.getGroupKey() + "/" + group.getWeight() + "/" + instanceId);
                }
            }
        }
        return routeRuleGroupKeys;
    }

    protected Set<String> generateServiceInstanceIds(List<Instance> instances) {
        HashSet instanceIds = Sets.newHashSet();
        if (CollectionExtension.isEmpty(instances)) {
            return instanceIds;
        }
        for (Instance instance : instances) {
            if (instance == null) continue;
            instanceIds.add(instance.getRegionId() + "/" + instance.getZoneId() + "/" + instance.getGroupId() + "/" + instance.getServiceId() + "/" + instance.getInstanceId() + "/" + instance.getMachineName() + "/" + instance.getIp() + "/" + instance.getPort() + "/" + instance.getProtocol() + "/" + instance.getUrl() + "/" + instance.getHealthCheckUrl() + "/" + StringUtil.toJson((Object)instance.getMetadata()));
        }
        return instanceIds;
    }

    protected Set<Long> refreshGroupOperationsCache() {
        HashMap newServiceGroupOperations = Maps.newHashMap();
        ArrayListMultimap m = ArrayListMultimap.create();
        for (GroupOperationModel model : this.groupOperationDao.query()) {
            m.put((Object)model.getGroupId(), (Object)model.getOperation());
        }
        for (Long id : m.keySet()) {
            GroupOperations groupOperations = new GroupOperations(id, m.get((Object)id));
            newServiceGroupOperations.put(id, groupOperations);
        }
        Set<Long> oldKeys = this.serviceGroupOperations.keySet();
        this.serviceGroupOperations = newServiceGroupOperations;
        return this.diff(oldKeys, this.serviceGroupOperations.keySet());
    }

    protected Set<Long> diff(Set<Long> key1, Set<Long> key2) {
        HashSet diffs = Sets.newHashSet((Iterable)Sets.difference(key1, key2));
        diffs.addAll(Sets.difference(key2, key1));
        return diffs;
    }

    protected void stopRefresh() {
        this.cacheRefresher.shutdown();
    }

    public static interface RouteRuleStatus {
        public static final String ACTIVE = "active";
        public static final String INACTIVE = "inactive";
    }

    public static interface GroupStatus {
        public static final String ACTIVE = "active";
        public static final String INACTIVE = "inactive";
    }

    public static interface Operation {
        public static final String CREATE = "create";
        public static final String DELETE = "delete";
        public static final String UPDATE = "update";
    }
}

