/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import com.google.common.collect.Lists;
import org.mydotey.artemis.HasResponseStatus;
import org.mydotey.artemis.management.GroupRepository;
import org.mydotey.artemis.management.ManagementServiceImpl;
import org.mydotey.artemis.management.group.CreateRouteRuleRequest;
import org.mydotey.artemis.management.group.CreateRouteRuleResponse;
import org.mydotey.artemis.management.group.DeleteGroupInstancesResponse;
import org.mydotey.artemis.management.group.DeleteGroupTagsRequest;
import org.mydotey.artemis.management.group.DeleteGroupTagsResponse;
import org.mydotey.artemis.management.group.DeleteGroupsInstancesRequest;
import org.mydotey.artemis.management.group.DeleteGroupsRequest;
import org.mydotey.artemis.management.group.DeleteGroupsResponse;
import org.mydotey.artemis.management.group.DeleteRouteRuleGroupsRequest;
import org.mydotey.artemis.management.group.DeleteRouteRuleGroupsResponse;
import org.mydotey.artemis.management.group.DeleteRouteRulesRequest;
import org.mydotey.artemis.management.group.DeleteRouteRulesResponse;
import org.mydotey.artemis.management.group.DeleteServiceInstancesRequest;
import org.mydotey.artemis.management.group.GetAllGroupOperationsRequest;
import org.mydotey.artemis.management.group.GetAllGroupOperationsResponse;
import org.mydotey.artemis.management.group.GetAllGroupTagsRequest;
import org.mydotey.artemis.management.group.GetAllGroupTagsResponse;
import org.mydotey.artemis.management.group.GetAllGroupsRequest;
import org.mydotey.artemis.management.group.GetAllGroupsResponse;
import org.mydotey.artemis.management.group.GetAllRouteRuleGroupsRequest;
import org.mydotey.artemis.management.group.GetAllRouteRuleGroupsResponse;
import org.mydotey.artemis.management.group.GetAllRouteRulesRequest;
import org.mydotey.artemis.management.group.GetAllRouteRulesResponse;
import org.mydotey.artemis.management.group.GetGroupInstancesRequest;
import org.mydotey.artemis.management.group.GetGroupInstancesResponse;
import org.mydotey.artemis.management.group.GetGroupOperationsRequest;
import org.mydotey.artemis.management.group.GetGroupOperationsResponse;
import org.mydotey.artemis.management.group.GetGroupTagsRequest;
import org.mydotey.artemis.management.group.GetGroupTagsResponse;
import org.mydotey.artemis.management.group.GetGroupsRequest;
import org.mydotey.artemis.management.group.GetGroupsResponse;
import org.mydotey.artemis.management.group.GetRouteRuleGroupsRequest;
import org.mydotey.artemis.management.group.GetRouteRuleGroupsResponse;
import org.mydotey.artemis.management.group.GetRouteRulesRequest;
import org.mydotey.artemis.management.group.GetRouteRulesResponse;
import org.mydotey.artemis.management.group.GetServiceInstancesRequest;
import org.mydotey.artemis.management.group.GetServiceInstancesResponse;
import org.mydotey.artemis.management.group.GroupService;
import org.mydotey.artemis.management.group.InsertGroupInstancesRequest;
import org.mydotey.artemis.management.group.InsertGroupInstancesResponse;
import org.mydotey.artemis.management.group.InsertGroupTagsRequest;
import org.mydotey.artemis.management.group.InsertGroupTagsResponse;
import org.mydotey.artemis.management.group.InsertGroupsRequest;
import org.mydotey.artemis.management.group.InsertGroupsResponse;
import org.mydotey.artemis.management.group.InsertRouteRuleGroupsRequest;
import org.mydotey.artemis.management.group.InsertRouteRuleGroupsResponse;
import org.mydotey.artemis.management.group.InsertRouteRulesRequest;
import org.mydotey.artemis.management.group.InsertRouteRulesResponse;
import org.mydotey.artemis.management.group.InsertServiceInstancesRequest;
import org.mydotey.artemis.management.group.OperateGroupOperationRequest;
import org.mydotey.artemis.management.group.OperateGroupOperationResponse;
import org.mydotey.artemis.management.group.OperateGroupOperationsRequest;
import org.mydotey.artemis.management.group.OperateGroupOperationsResponse;
import org.mydotey.artemis.management.group.OperationResponse;
import org.mydotey.artemis.management.group.ReleaseRouteRuleGroupsRequest;
import org.mydotey.artemis.management.group.ReleaseRouteRuleGroupsResponse;
import org.mydotey.artemis.management.group.RouteRuleInfo;
import org.mydotey.artemis.management.group.UpdateGroupTagsRequest;
import org.mydotey.artemis.management.group.UpdateGroupTagsResponse;
import org.mydotey.artemis.management.group.UpdateGroupsRequest;
import org.mydotey.artemis.management.group.UpdateGroupsResponse;
import org.mydotey.artemis.management.group.UpdateRouteRuleGroupsRequest;
import org.mydotey.artemis.management.group.UpdateRouteRuleGroupsResponse;
import org.mydotey.artemis.management.group.UpdateRouteRulesRequest;
import org.mydotey.artemis.management.group.UpdateRouteRulesResponse;
import org.mydotey.artemis.management.group.model.GroupInstanceModel;
import org.mydotey.artemis.management.group.model.GroupModel;
import org.mydotey.artemis.management.group.model.GroupTagModel;
import org.mydotey.artemis.management.group.model.RouteRuleGroupModel;
import org.mydotey.artemis.management.group.model.RouteRuleModel;
import org.mydotey.artemis.management.group.model.ServiceInstanceModel;
import org.mydotey.artemis.management.group.util.GroupInstances;
import org.mydotey.artemis.management.group.util.GroupOperationsUtil;
import org.mydotey.artemis.management.group.util.GroupTagsUtil;
import org.mydotey.artemis.management.group.util.Groups;
import org.mydotey.artemis.management.group.util.RouteRuleGroups;
import org.mydotey.artemis.management.group.util.ServiceInstances;
import org.mydotey.artemis.management.group.util.ServiceRouteRules;
import org.mydotey.artemis.ratelimiter.ArtemisRateLimiterManager;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.mydotey.artemis.util.ServiceNodeUtil;
import org.mydotey.caravan.util.ratelimiter.RateLimiter;
import org.mydotey.caravan.util.ratelimiter.RateLimiterConfig;
import org.mydotey.scf.filter.RangeValueConfig;
import org.mydotey.util.TimeSequenceCircularBufferConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupServiceImpl
implements GroupService {
    private static volatile GroupServiceImpl instance;
    private static final Logger logger;
    private final GroupRepository groupRepository = GroupRepository.getInstance();
    private final RateLimiter rateLimiter = ArtemisRateLimiterManager.Instance.getRateLimiter("artemis.service.management.group", new RateLimiterConfig(true, new RangeValueConfig((Comparable)Long.valueOf(30L), (Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(1000L)), ((TimeSequenceCircularBufferConfig.Builder)((TimeSequenceCircularBufferConfig.Builder)new TimeSequenceCircularBufferConfig.Builder().setTimeWindow(10000L)).setBucketTtl(1000L)).build()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<GroupServiceImpl> clazz = GroupServiceImpl.class;
        synchronized (GroupServiceImpl.class) {
            if (instance != null) return instance;
            instance = new GroupServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GroupServiceImpl() {
    }

    @Override
    public InsertRouteRulesResponse insertRouteRules(InsertRouteRulesRequest request) {
        return (InsertRouteRulesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.insert.route-rules", () -> {
            InsertRouteRulesResponse response = new InsertRouteRulesResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.insertRouteRules(request, ServiceRouteRules.newRouteRuleModels(request.getRouteRules()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "insert route-rules failed.", response);
            }
        });
    }

    @Override
    public UpdateRouteRulesResponse updateRouteRules(UpdateRouteRulesRequest request) {
        return (UpdateRouteRulesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.update.route-rules", () -> {
            UpdateRouteRulesResponse response = new UpdateRouteRulesResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.updateRouteRules(request, ServiceRouteRules.newRouteRuleModels(request.getRouteRules()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "update route-rules failed.", response);
            }
        });
    }

    @Override
    public DeleteRouteRulesResponse deleteRouteRules(DeleteRouteRulesRequest request) {
        return (DeleteRouteRulesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.delete.route-rules", () -> {
            DeleteRouteRulesResponse response = new DeleteRouteRulesResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.deleteRouteRules(request, request.getRouteRuleIds());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "delete route-rules failed.", response);
            }
        });
    }

    @Override
    public GetAllRouteRulesResponse getAllRouteRules(GetAllRouteRulesRequest request) {
        return (GetAllRouteRulesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.all-route-rules", () -> {
            GetAllRouteRulesResponse response = new GetAllRouteRulesResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setRouteRules(this.groupRepository.getAllRouteRules(request.getRegionId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get all-route-rules failed.", response);
            }
        });
    }

    @Override
    public GetRouteRulesResponse getRouteRules(GetRouteRulesRequest request) {
        return (GetRouteRulesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.route-rules", () -> {
            GetRouteRulesResponse response = new GetRouteRulesResponse();
            if (this.rateLimiter.isRateLimited("get.route-rules")) {
                response.setResponseStatus(ResponseStatusUtil.RATE_LIMITED_STATUS);
                return response;
            }
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setRouteRules(this.groupRepository.getRouteRules(new RouteRuleModel(request.getRouteRuleId(), request.getServiceId(), request.getName(), request.getStatus())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get route-rules failed.", response);
            }
        });
    }

    @Override
    public InsertRouteRuleGroupsResponse insertRouteRuleGroups(InsertRouteRuleGroupsRequest request) {
        return (InsertRouteRuleGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.insert.route-rule-groups", () -> {
            InsertRouteRuleGroupsResponse response = new InsertRouteRuleGroupsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.insertServiceRouteRuleGroups(request, RouteRuleGroups.newRouteRuleGroupModels(request.getRouteRuleGroups()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "insert route-rule-groups failed.", response);
            }
        });
    }

    @Override
    public UpdateRouteRuleGroupsResponse updateRouteRuleGroups(UpdateRouteRuleGroupsRequest request) {
        return (UpdateRouteRuleGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.update.route-rule-groups", () -> {
            UpdateRouteRuleGroupsResponse response = new UpdateRouteRuleGroupsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.updateServiceRouteRuleGroups(request, RouteRuleGroups.newRouteRuleGroupModels(request.getRouteRuleGroups()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "update route-rule-groups failed.", response);
            }
        });
    }

    @Override
    public DeleteRouteRuleGroupsResponse deleteRouteRuleGroups(DeleteRouteRuleGroupsRequest request) {
        return (DeleteRouteRuleGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.delete.route-rule-groups", () -> {
            DeleteRouteRuleGroupsResponse response = new DeleteRouteRuleGroupsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.deleteServiceRouteRuleGroups(request, request.getRouteRuleGroupIds());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "delete route-rule-groups failed.", response);
            }
        });
    }

    @Override
    public GetAllRouteRuleGroupsResponse getAllRouteRuleGroups(GetAllRouteRuleGroupsRequest request) {
        return (GetAllRouteRuleGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.all-route-rule-group", () -> {
            GetAllRouteRuleGroupsResponse response = new GetAllRouteRuleGroupsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setRouteRuleGroups(this.groupRepository.getAllRouteRuleGroups(request.getRegionId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get all route-rule-group failed.", response);
            }
        });
    }

    @Override
    public GetRouteRuleGroupsResponse getRouteRuleGroups(GetRouteRuleGroupsRequest request) {
        return (GetRouteRuleGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.route-rule-groups", () -> {
            GetRouteRuleGroupsResponse response = new GetRouteRuleGroupsResponse();
            if (this.rateLimiter.isRateLimited("get.route-rule-groups")) {
                response.setResponseStatus(ResponseStatusUtil.RATE_LIMITED_STATUS);
                return response;
            }
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setRouteRuleGroups(this.groupRepository.getRouteRuleGroups(new RouteRuleGroupModel(request.getRouteRuleGroupId(), request.getRouteRuleId(), request.getGroupId())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get route-rule-groups failed.", response);
            }
        });
    }

    @Override
    public ReleaseRouteRuleGroupsResponse releaseRouteRuleGroups(ReleaseRouteRuleGroupsRequest request) {
        return (ReleaseRouteRuleGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.release.route-rule-groups", () -> {
            ReleaseRouteRuleGroupsResponse response = new ReleaseRouteRuleGroupsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.releaseServiceRouteRuleGroups(request, RouteRuleGroups.newRouteRuleGroupModels(request.getRouteRuleGroups()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get route-rule-groups failed.", response);
            }
        });
    }

    @Override
    public InsertGroupsResponse insertGroups(InsertGroupsRequest request) {
        return (InsertGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.insert.groups", () -> {
            InsertGroupsResponse response = new InsertGroupsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.insertGroups(request, Groups.newGroupModels(request.getGroups()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "insert groups failed.", response);
            }
        });
    }

    @Override
    public UpdateGroupsResponse updateGroups(UpdateGroupsRequest request) {
        return (UpdateGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.update.groups", () -> {
            UpdateGroupsResponse response = new UpdateGroupsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.updateGroups(request, Groups.newGroupModels(request.getGroups()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "update groups failed.", response);
            }
        });
    }

    @Override
    public DeleteGroupsResponse deleteGroups(DeleteGroupsRequest request) {
        return (DeleteGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.delete.group", () -> {
            DeleteGroupsResponse response = new DeleteGroupsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.deleteGroups(request, request.getGroupIds());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "delete group failed.", response);
            }
        });
    }

    @Override
    public GetAllGroupsResponse getAllGroups(GetAllGroupsRequest request) {
        return (GetAllGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.all-group", () -> {
            GetAllGroupsResponse response = new GetAllGroupsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setGroups(this.groupRepository.getAllGroups(request.getRegionId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get all group failed.", response);
            }
        });
    }

    @Override
    public GetGroupsResponse getGroups(GetGroupsRequest request) {
        return (GetGroupsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.groups", () -> {
            GetGroupsResponse response = new GetGroupsResponse();
            if (this.rateLimiter.isRateLimited("get.groups")) {
                response.setResponseStatus(ResponseStatusUtil.RATE_LIMITED_STATUS);
                return response;
            }
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setGroups(this.groupRepository.getGroups(new GroupModel(request.getServiceId(), request.getRegionId(), request.getZoneId(), request.getName(), request.getAppId(), null, request.getStatus())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get groups failed.", response);
            }
        });
    }

    @Override
    public OperateGroupOperationsResponse operateGroupOperations(OperateGroupOperationsRequest request) {
        return (OperateGroupOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.operate-group-operations", () -> {
            OperateGroupOperationsResponse response = new OperateGroupOperationsResponse();
            if (!ServiceNodeUtil.checkCurrentNode((HasResponseStatus)response)) {
                return response;
            }
            if (request == null) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
                return response;
            }
            try {
                this.groupRepository.operateGroupOperations(request, GroupOperationsUtil.newGroupOperationModels(request.getGroupOperationsList()), request.isOperationComplete());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "operate group operation failed.", response);
            }
        });
    }

    @Override
    public GetAllGroupOperationsResponse getAllGroupOperations(GetAllGroupOperationsRequest request) {
        return (GetAllGroupOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.all-group-operations", () -> {
            GetAllGroupOperationsResponse response = new GetAllGroupOperationsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setAllGroupOperations(this.groupRepository.getAllGroupOperations(request.getRegionId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get all group operations failed.", response);
            }
        });
    }

    @Override
    public GetGroupOperationsResponse getGroupOperations(GetGroupOperationsRequest request) {
        return (GetGroupOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.group-operations", () -> {
            GetGroupOperationsResponse response = new GetGroupOperationsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setGroupOperations(this.groupRepository.getGroupOperations(request.getGroupId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get group operations failed.", response);
            }
        });
    }

    @Override
    public InsertGroupTagsResponse insertGroupTags(InsertGroupTagsRequest request) {
        return (InsertGroupTagsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.insert.group-tags", () -> {
            InsertGroupTagsResponse response = new InsertGroupTagsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.insertGroupTags(GroupTagsUtil.newGroupTags(request.getGroupTagsList()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "insert group tag failed.", response);
            }
        });
    }

    @Override
    public UpdateGroupTagsResponse updateGroupTags(UpdateGroupTagsRequest request) {
        return (UpdateGroupTagsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.update.group-tags", () -> {
            UpdateGroupTagsResponse response = new UpdateGroupTagsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.updateGroupTags(GroupTagsUtil.newGroupTags(request.getGroupTagsList()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "update group tag failed.", response);
            }
        });
    }

    @Override
    public DeleteGroupTagsResponse deleteGroupTags(DeleteGroupTagsRequest request) {
        return (DeleteGroupTagsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.delete.group-tags", () -> {
            DeleteGroupTagsResponse response = new DeleteGroupTagsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.deleteGroupTags(new GroupTagModel(request.getGroupId(), request.getTag(), request.getValue()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "delete group-tags failed.", response);
            }
        });
    }

    @Override
    public GetGroupTagsResponse getGroupTags(GetGroupTagsRequest request) {
        return (GetGroupTagsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.group-tags", () -> {
            GetGroupTagsResponse response = new GetGroupTagsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setGroupTags(this.groupRepository.getGroupTags(request.getGroupId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get group-tags failed.", response);
            }
        });
    }

    @Override
    public GetAllGroupTagsResponse getAllGroupTags(GetAllGroupTagsRequest request) {
        return (GetAllGroupTagsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.all-group-tags", () -> {
            GetAllGroupTagsResponse response = new GetAllGroupTagsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setAllGroupTags(this.groupRepository.getAllGroupTags(request.getRegionId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get all-group-tags failed.", response);
            }
        });
    }

    @Override
    public CreateRouteRuleResponse createRouteRule(CreateRouteRuleRequest request) {
        return (CreateRouteRuleResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.create-route-rule", () -> {
            CreateRouteRuleResponse response = new CreateRouteRuleResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.createRouteRules(request, request.getRouteRule().getServiceId(), Lists.newArrayList((Object[])new RouteRuleInfo[]{new RouteRuleInfo(request.getRouteRule(), request.getGroups())}));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "create route-rule failed.", response);
            }
        });
    }

    @Override
    public OperateGroupOperationResponse operateGroupOperation(OperateGroupOperationRequest request) {
        return (OperateGroupOperationResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.operate.group-operation", () -> {
            OperateGroupOperationResponse response = new OperateGroupOperationResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                GroupModel group = new GroupModel(request.getServiceId(), request.getRegionId(), request.getZoneId(), request.getName(), request.getAppId(), request.getDescription(), request.getStatus());
                this.groupRepository.operateGroupOperation(request, group, request.isOperationComplete());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "operate group operation failed.", response);
            }
        });
    }

    @Override
    public InsertGroupInstancesResponse insertGroupInstances(InsertGroupInstancesRequest request) {
        return (InsertGroupInstancesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.insert.group-instances", () -> {
            InsertGroupInstancesResponse response = new InsertGroupInstancesResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.insertGroupInstances(request, GroupInstances.newGroupInstanceModels(request.getGroupInstances()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "insert group instances failed.", response);
            }
        });
    }

    @Override
    public DeleteGroupInstancesResponse deleteGroupInstances(DeleteGroupsInstancesRequest request) {
        return (DeleteGroupInstancesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.delete.group-instances", () -> {
            DeleteGroupInstancesResponse response = new DeleteGroupInstancesResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.deleteGroupInstances(request, request.getGroupInstanceIds());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "delete group instances failed.", response);
            }
        });
    }

    @Override
    public GetGroupInstancesResponse getGroupInstances(GetGroupInstancesRequest request) {
        return (GetGroupInstancesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.group-instances", () -> {
            GetGroupInstancesResponse response = new GetGroupInstancesResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setGroupInstances(this.groupRepository.getGroupInstances(new GroupInstanceModel(request.getGroupId(), request.getInstanceId())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get group instances failed.", response);
            }
        });
    }

    @Override
    public OperationResponse insertServiceInstances(InsertServiceInstancesRequest request) {
        return (OperationResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.insert.service-instances", () -> {
            OperationResponse response = new OperationResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.insertServiceInstances(request, ServiceInstances.newServiceInstanceModels(request.getServiceInstances()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "insert service instances failed.", response);
            }
        });
    }

    @Override
    public OperationResponse deleteServiceInstances(DeleteServiceInstancesRequest request) {
        return (OperationResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.delete.service-instances", () -> {
            OperationResponse response = new OperationResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.groupRepository.deleteServiceInstances(request, request.getServiceInstanceIds());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "delete service instances failed.", response);
            }
        });
    }

    @Override
    public GetServiceInstancesResponse getServiceInstances(GetServiceInstancesRequest request) {
        return (GetServiceInstancesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.service-instances", () -> {
            GetServiceInstancesResponse response = new GetServiceInstancesResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setServiceInstances(this.groupRepository.getServiceInstances(new ServiceInstanceModel(request.getServiceId(), request.getInstanceId())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                return this.processException(ex, "get service instances failed.", response);
            }
        });
    }

    private boolean check(Object request, HasResponseStatus response) {
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return false;
        }
        return true;
    }

    private boolean updateCheck(Object request, HasResponseStatus response) {
        return ServiceNodeUtil.checkCurrentNode((HasResponseStatus)response) && this.check(request, response);
    }

    private <T extends HasResponseStatus> T processException(Throwable ex, String errorMessage, T response) {
        logger.error(errorMessage, ex);
        response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)errorMessage, (String)"internal-service-error"));
        return response;
    }

    static {
        logger = LoggerFactory.getLogger(ManagementServiceImpl.class);
    }
}

