/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import java.util.ArrayList;
import java.util.List;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.artemis.discovery.DiscoveryFilter;
import org.mydotey.artemis.management.ManagementRepository;
import org.mydotey.java.collection.CollectionExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger logger = LoggerFactory.getLogger(ManagementDiscoveryFilter.class);
    private static ManagementDiscoveryFilter _instance;
    private ManagementRepository _managementRepository = ManagementRepository.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ManagementDiscoveryFilter getInstance() {
        if (_instance != null) return _instance;
        Class<ManagementDiscoveryFilter> clazz = ManagementDiscoveryFilter.class;
        synchronized (ManagementDiscoveryFilter.class) {
            if (_instance != null) return _instance;
            _instance = new ManagementDiscoveryFilter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private ManagementDiscoveryFilter() {
    }

    public void filter(Service service, DiscoveryConfig discoveryConfig) {
        if (service == null) {
            return;
        }
        service.setInstances(this.removeDownInstances(service.getInstances()));
        service.setLogicInstances(this.removeDownInstances(service.getLogicInstances()));
    }

    private List<Instance> removeDownInstances(List<Instance> instances) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        if (!CollectionExtension.isEmpty(instances)) {
            for (Instance instance : instances) {
                if (this._managementRepository.isInstanceDown(instance)) {
                    String message = String.format("Instance %s removed by management discovery filter.", instance.toString());
                    logger.info(message);
                    continue;
                }
                result.add(instance);
            }
        }
        return result;
    }
}

