/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mydotey.artemis.cluster.NodeInitializer;
import org.mydotey.artemis.cluster.NodeManager;
import org.mydotey.artemis.discovery.DiscoveryFilter;
import org.mydotey.artemis.discovery.DiscoveryFilters;
import org.mydotey.artemis.discovery.notify.NotificationCenter;
import org.mydotey.artemis.discovery.notify.NotificationFilter;
import org.mydotey.artemis.management.GroupDiscoveryFilter;
import org.mydotey.artemis.management.GroupRepository;
import org.mydotey.artemis.management.ManagementDiscoveryFilter;
import org.mydotey.artemis.management.ManagementNotificationFilter;
import org.mydotey.artemis.management.ManagementRepository;
import org.mydotey.artemis.management.ZoneRepository;
import org.mydotey.artemis.management.dao.DataConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementInitializer
implements NodeInitializer {
    private static Logger _logger = LoggerFactory.getLogger(ManagementInitializer.class);
    public static final ManagementInitializer INSTANCE = new ManagementInitializer();
    private AtomicBoolean _started = new AtomicBoolean();

    private ManagementInitializer() {
    }

    public void init() throws Exception {
        if (!this._started.compareAndSet(false, true)) {
            return;
        }
        _logger.info("===== Artemis Management is starting up! ========");
        DataConfig.init();
        GroupRepository.getInstance().init();
        ZoneRepository.getInstance().init();
        ManagementRepository.getInstance().init();
        ManagementRepository.getInstance().addFilter(GroupDiscoveryFilter.getInstance());
        NodeManager.INSTANCE.registerInitializer((NodeInitializer)this);
        DiscoveryFilters.INSTANCE.registerFilter(new DiscoveryFilter[]{GroupDiscoveryFilter.getInstance(), ManagementDiscoveryFilter.getInstance()});
        NotificationCenter.getInstance().registerFilter((NotificationFilter)new ManagementNotificationFilter());
    }

    public NodeInitializer.TargetType target() {
        return NodeInitializer.TargetType.DISCOVERY;
    }

    public boolean initialized() {
        return ManagementRepository.getInstance().isLastRefreshSuccess() && GroupRepository.getInstance().isLastRefreshSuccess();
    }
}

