/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import org.mydotey.artemis.HasResponseStatus;
import org.mydotey.artemis.management.dao.InstanceLogDao;
import org.mydotey.artemis.management.dao.InstanceLogModel;
import org.mydotey.artemis.management.dao.ServerLogDao;
import org.mydotey.artemis.management.dao.ServerLogModel;
import org.mydotey.artemis.management.group.dao.GroupInstanceLogDao;
import org.mydotey.artemis.management.group.dao.GroupLogDao;
import org.mydotey.artemis.management.group.dao.GroupOperationLogDao;
import org.mydotey.artemis.management.group.dao.RouteRuleGroupLogDao;
import org.mydotey.artemis.management.group.dao.RouteRuleLogDao;
import org.mydotey.artemis.management.group.dao.ServiceInstanceLogDao;
import org.mydotey.artemis.management.group.model.GroupInstanceLogModel;
import org.mydotey.artemis.management.group.model.GroupLogModel;
import org.mydotey.artemis.management.group.model.GroupOperationLogModel;
import org.mydotey.artemis.management.group.model.RouteRuleGroupLogModel;
import org.mydotey.artemis.management.group.model.RouteRuleLogModel;
import org.mydotey.artemis.management.group.model.ServiceInstanceLogModel;
import org.mydotey.artemis.management.log.GetGroupInstanceLogsRequest;
import org.mydotey.artemis.management.log.GetGroupInstanceLogsResponse;
import org.mydotey.artemis.management.log.GetGroupLogsRequest;
import org.mydotey.artemis.management.log.GetGroupLogsResponse;
import org.mydotey.artemis.management.log.GetGroupOperationLogsRequest;
import org.mydotey.artemis.management.log.GetGroupOperationLogsResponse;
import org.mydotey.artemis.management.log.GetInstanceOperationLogsRequest;
import org.mydotey.artemis.management.log.GetInstanceOperationLogsResponse;
import org.mydotey.artemis.management.log.GetRouteRuleGroupLogsRequest;
import org.mydotey.artemis.management.log.GetRouteRuleGroupLogsResponse;
import org.mydotey.artemis.management.log.GetRouteRuleLogsRequest;
import org.mydotey.artemis.management.log.GetRouteRuleLogsResponse;
import org.mydotey.artemis.management.log.GetServerOperationLogsRequest;
import org.mydotey.artemis.management.log.GetServerOperationLogsResponse;
import org.mydotey.artemis.management.log.GetServiceInstanceLogsRequest;
import org.mydotey.artemis.management.log.GetServiceInstanceLogsResponse;
import org.mydotey.artemis.management.log.GetZoneOperationLogsRequest;
import org.mydotey.artemis.management.log.GetZoneOperationLogsResponse;
import org.mydotey.artemis.management.log.ManagementLogService;
import org.mydotey.artemis.management.zone.dao.ZoneOperationLogDao;
import org.mydotey.artemis.management.zone.model.ZoneOperationLogModel;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.ResponseStatusUtil;

public class ManagementLogServiceImpl
implements ManagementLogService {
    private static ManagementLogServiceImpl _instance;
    private final InstanceLogDao instanceLogDao = InstanceLogDao.INSTANCE;
    private final ServerLogDao serverLogDao = ServerLogDao.INSTANCE;
    private final GroupOperationLogDao groupOperationLogDao = GroupOperationLogDao.INSTANCE;
    private final GroupLogDao groupLogDao = GroupLogDao.INSTANCE;
    private final RouteRuleLogDao routeRuleLogDao = RouteRuleLogDao.INSTANCE;
    private final RouteRuleGroupLogDao routeRuleGroupLogDao = RouteRuleGroupLogDao.INSTANCE;
    private final GroupInstanceLogDao groupInstanceLogDao = GroupInstanceLogDao.INSTANCE;
    private final ZoneOperationLogDao zoneOperationLogDao = ZoneOperationLogDao.INSTANCE;
    private final ServiceInstanceLogDao serviceInstanceLogDao = ServiceInstanceLogDao.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ManagementLogServiceImpl getInstance() {
        if (_instance != null) return _instance;
        Class<ManagementLogServiceImpl> clazz = ManagementLogServiceImpl.class;
        synchronized (ManagementLogServiceImpl.class) {
            if (_instance != null) return _instance;
            _instance = new ManagementLogServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private ManagementLogServiceImpl() {
    }

    @Override
    public GetInstanceOperationLogsResponse getInstanceOperationLogs(GetInstanceOperationLogsRequest request) {
        return (GetInstanceOperationLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.instance-operation-logs", () -> {
            GetInstanceOperationLogsResponse response = new GetInstanceOperationLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.instanceLogDao.select(new InstanceLogModel(request.getRegionId(), request.getServiceId(), request.getInstanceId(), request.getOperation(), request.getOperatorId()), request.getComplete()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetServerOperationLogsResponse getServerOperationLogs(GetServerOperationLogsRequest request) {
        return (GetServerOperationLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.server-operation-logs", () -> {
            GetServerOperationLogsResponse response = new GetServerOperationLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.serverLogDao.select(new ServerLogModel(request.getRegionId(), request.getServerId(), request.getOperation(), request.getOperatorId()), request.getComplete()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetGroupOperationLogsResponse getGroupOperationLogs(GetGroupOperationLogsRequest request) {
        return (GetGroupOperationLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.group-operation-logs", () -> {
            GetGroupOperationLogsResponse response = new GetGroupOperationLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.groupOperationLogDao.select(new GroupOperationLogModel(request.getGroupId(), request.getOperation(), request.getOperatorId()), request.getComplete()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetGroupLogsResponse getGroupLogs(GetGroupLogsRequest request) {
        return (GetGroupLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.group-logs", () -> {
            GetGroupLogsResponse response = new GetGroupLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.groupLogDao.select(new GroupLogModel(request.getServiceId(), request.getRegionId(), request.getZoneId(), request.getName(), request.getAppId(), request.getOperation(), request.getOperatorId())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetRouteRuleLogsResponse getRouteRuleLogs(GetRouteRuleLogsRequest request) {
        return (GetRouteRuleLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.route-rule-logs", () -> {
            GetRouteRuleLogsResponse response = new GetRouteRuleLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.routeRuleLogDao.select(new RouteRuleLogModel(request.getServiceId(), request.getName(), request.getOperation(), request.getOperatorId())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetRouteRuleGroupLogsResponse getRouteRuleGroupLogs(GetRouteRuleGroupLogsRequest request) {
        return (GetRouteRuleGroupLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.route-rule-group-logs", () -> {
            GetRouteRuleGroupLogsResponse response = new GetRouteRuleGroupLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.routeRuleGroupLogDao.select(new RouteRuleGroupLogModel(request.getRouteRuleId(), request.getGroupId(), request.getOperatorId(), request.getOperation())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetZoneOperationLogsResponse getZoneOperationLogs(GetZoneOperationLogsRequest request) {
        return (GetZoneOperationLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.zone-operation-logs", () -> {
            GetZoneOperationLogsResponse response = new GetZoneOperationLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.zoneOperationLogDao.select(new ZoneOperationLogModel(request.getOperation(), request.getZoneId(), request.getServiceId(), request.getRegionId(), request.getOperatorId()), request.getComplete()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetGroupInstanceLogsResponse getGroupInstanceLogs(GetGroupInstanceLogsRequest request) {
        return (GetGroupInstanceLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.group-instance-logs", () -> {
            GetGroupInstanceLogsResponse response = new GetGroupInstanceLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.groupInstanceLogDao.select(new GroupInstanceLogModel(request.getGroupId(), request.getInstanceId(), request.getOperatorId(), request.getOperation())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetServiceInstanceLogsResponse getServiceInstanceLogs(GetServiceInstanceLogsRequest request) {
        return (GetServiceInstanceLogsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management-log.service-instance-logs", () -> {
            GetServiceInstanceLogsResponse response = new GetServiceInstanceLogsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setLogs(this.serviceInstanceLogDao.select(new ServiceInstanceLogModel(request.getServiceId(), request.getInstanceId(), request.getOperatorId(), request.getOperation())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Exception e) {
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)e.getMessage(), (String)"internal-service-error"));
                return response;
            }
        });
    }

    private boolean check(Object request, HasResponseStatus response) {
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return false;
        }
        return true;
    }
}

