/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.InstanceChange;
import org.mydotey.artemis.InstanceKey;
import org.mydotey.artemis.ServerKey;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.cluster.NodeManager;
import org.mydotey.artemis.cluster.ServiceNodeStatus;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.artemis.discovery.DiscoveryFilter;
import org.mydotey.artemis.lease.Lease;
import org.mydotey.artemis.management.GroupRepository;
import org.mydotey.artemis.management.ZoneRepository;
import org.mydotey.artemis.management.dao.InstanceDao;
import org.mydotey.artemis.management.dao.InstanceLogDao;
import org.mydotey.artemis.management.dao.InstanceLogModel;
import org.mydotey.artemis.management.dao.InstanceModel;
import org.mydotey.artemis.management.dao.ServerDao;
import org.mydotey.artemis.management.dao.ServerLogDao;
import org.mydotey.artemis.management.dao.ServerLogModel;
import org.mydotey.artemis.management.dao.ServerModel;
import org.mydotey.artemis.management.instance.InstanceOperations;
import org.mydotey.artemis.management.server.ServerOperations;
import org.mydotey.artemis.management.zone.ZoneKey;
import org.mydotey.artemis.registry.RegistryRepository;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.InstanceChanges;
import org.mydotey.artemis.util.ServiceNodeUtil;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;
import org.mydotey.java.ThreadExtension;
import org.mydotey.java.collection.CollectionExtension;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueConfig;
import org.mydotey.scf.filter.RangeValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementRepository {
    private static final Logger _logger = LoggerFactory.getLogger(ManagementRepository.class);
    private static ManagementRepository _instance;
    private Property<String, Integer> _managementDBSyncWaitTimeProperty = ArtemisConfig.properties().getIntProperty((Object)"artemis.management.db-sync.wait-time", Integer.valueOf(2000), (Function)new RangeValueFilter((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(60000)));
    private InstanceDao _instanceDao = InstanceDao.INSTANCE;
    private ServerDao _serverDao = ServerDao.INSTANCE;
    private InstanceLogDao _instanceLogDao = InstanceLogDao.INSTANCE;
    private ServerLogDao _serverLogDao = ServerLogDao.INSTANCE;
    private RegistryRepository _registryRepository = RegistryRepository.getInstance();
    private GroupRepository groupRepository = GroupRepository.getInstance();
    private ZoneRepository zoneRepository = ZoneRepository.getInstance();
    private volatile Map<InstanceKey, InstanceOperations> _allInstanceOperationsMap = new HashMap<InstanceKey, InstanceOperations>();
    private volatile Map<ServerKey, ServerOperations> _allServerOperationsMap = new HashMap<ServerKey, ServerOperations>();
    private volatile boolean _lastRefreshSuccess;
    private volatile long _lastRefreshTime;
    private DynamicScheduledThread _cacheRefresher;
    private final List<DiscoveryFilter> filters = Lists.newArrayList();
    private AtomicBoolean _inited = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ManagementRepository getInstance() {
        if (_instance != null) return _instance;
        Class<ManagementRepository> clazz = ManagementRepository.class;
        synchronized (ManagementRepository.class) {
            if (_instance != null) return _instance;
            _instance = new ManagementRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public static InstanceKey toInstanceKey(InstanceModel instance) {
        if (instance == null) {
            return InstanceKey.EMPTY;
        }
        return new InstanceKey(instance.getRegionId(), instance.getServiceId(), instance.getInstanceId());
    }

    public static ServerKey toServerKey(ServerModel server) {
        if (server == null) {
            return ServerKey.EMPTY;
        }
        return new ServerKey(server.getRegionId(), server.getServerId());
    }

    private ManagementRepository() {
    }

    public void init() {
        if (!this._inited.compareAndSet(false, true)) {
            return;
        }
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(ArtemisConfig.properties(), new RangeValueConfig((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10000)), new RangeValueConfig((Comparable)Integer.valueOf(1000), (Comparable)Integer.valueOf(200), (Comparable)Integer.valueOf(60000)));
        String cacheRefreshKey = "artemis.management.data.cache-refresher";
        this._cacheRefresher = new DynamicScheduledThread("artemis.management.data.cache-refresher", () -> {
            this._lastRefreshTime = System.currentTimeMillis();
            this._lastRefreshSuccess = (Boolean)ArtemisTraceExecutor.INSTANCE.execute("artemis.management.data.cache-refresher", () -> this.refreshCache());
        }, dynamicScheduledThreadConfig);
        this._cacheRefresher.setDaemon(true);
        this._cacheRefresher.start();
    }

    public synchronized void addFilter(DiscoveryFilter ... filters) {
        if (CollectionExtension.isEmpty((Object[])filters)) {
            return;
        }
        for (DiscoveryFilter filter : filters) {
            if (filter == null) continue;
            this.filters.add(filter);
        }
    }

    public boolean isLastRefreshSuccess() {
        return this._lastRefreshSuccess;
    }

    public long lastRefreshTime() {
        return this._lastRefreshTime;
    }

    public boolean isInstanceDown(Instance instance) {
        if (this.getInstanceOperations(InstanceKey.of((Instance)instance)) != null) {
            return true;
        }
        if (this.isServerDown(ServerKey.of((Instance)instance))) {
            return true;
        }
        if (this.zoneRepository.isZoneDown(ZoneKey.of(instance))) {
            return true;
        }
        return this.groupRepository.isInstanceDown(instance);
    }

    public boolean isServerDown(ServerKey serverKey) {
        return this.getServerOperations(serverKey) != null;
    }

    public InstanceOperations getInstanceOperations(InstanceKey instanceKey) {
        ObjectExtension.requireNonNull((Object)instanceKey, (String)"instanceKey");
        return this._allInstanceOperationsMap.get(instanceKey);
    }

    public ServerOperations getServerOperations(ServerKey serverKey) {
        ObjectExtension.requireNonNull((Object)serverKey, (String)"serverKey");
        return this._allServerOperationsMap.get(serverKey);
    }

    public void insertServer(ServerModel server) {
        this._serverDao.insert(server);
        this._serverLogDao.insert(ServerLogModel.of(server, false));
    }

    public void deleteServer(ServerModel server) {
        this._serverDao.delete(server);
        this._serverLogDao.insert(ServerLogModel.of(server, true));
    }

    public void insertInstance(InstanceModel instance) {
        this.insertInstances(Lists.newArrayList((Object[])new InstanceModel[]{instance}));
    }

    public void deleteInstance(InstanceModel instance) {
        this.deleteInstances(Lists.newArrayList((Object[])new InstanceModel[]{instance}));
    }

    public void insertInstances(List<InstanceModel> instances) {
        this._instanceDao.insert(instances);
        this._instanceLogDao.insert(InstanceLogModel.of(instances, false));
    }

    public void deleteInstances(List<InstanceModel> instances) {
        this._instanceDao.delete(instances);
        this._instanceLogDao.insert(InstanceLogModel.of(instances, true));
    }

    public void destroyServers(List<ServerKey> serverKeys) {
        this._serverDao.destroyServers(serverKeys);
        this._instanceDao.destroyServers(serverKeys);
    }

    public List<InstanceModel> queryInstances(String regionId, List<String> serviceIds) {
        return this._instanceDao.queryInstances(regionId, serviceIds);
    }

    public List<InstanceOperations> getAllInstanceOperations() {
        return new ArrayList<InstanceOperations>(this._allInstanceOperationsMap.values());
    }

    public List<InstanceOperations> getAllInstanceOperations(String regionId) {
        if (StringExtension.isBlank((String)regionId)) {
            return this.getAllInstanceOperations();
        }
        ArrayList<InstanceOperations> result = new ArrayList<InstanceOperations>();
        for (InstanceOperations instanceOperations : this._allInstanceOperationsMap.values()) {
            if (!regionId.equals(instanceOperations.getInstanceKey().getRegionId())) continue;
            result.add(instanceOperations);
        }
        return result;
    }

    public List<ServerOperations> getAllServerOperations() {
        return new ArrayList<ServerOperations>(this._allServerOperationsMap.values());
    }

    public List<ServerOperations> getAllServerOperations(String regionId) {
        if (StringExtension.isBlank((String)regionId)) {
            return this.getAllServerOperations();
        }
        ArrayList<ServerOperations> result = new ArrayList<ServerOperations>();
        for (ServerOperations serverOperations : this._allServerOperationsMap.values()) {
            if (!regionId.equals(serverOperations.getServerKey().getRegionId())) continue;
            result.add(serverOperations);
        }
        return result;
    }

    public List<Service> getAllServices() {
        List services = this._registryRepository.getServices();
        for (Service service : services) {
            this.setServiceInstances(service);
            this.filterService(service, new DiscoveryConfig(service.getServiceId()));
        }
        return services;
    }

    public Service getService(String serviceId) {
        if (StringExtension.isBlank((String)serviceId)) {
            return null;
        }
        Service service = this._registryRepository.getService(serviceId);
        this.setServiceInstances(service);
        if (service == null) {
            service = new Service(serviceId);
        }
        this.filterService(service, new DiscoveryConfig(serviceId));
        return service;
    }

    private void setServiceInstances(Service service) {
        if (service == null) {
            return;
        }
        String serviceId = service.getServiceId();
        if (StringExtension.isBlank((String)serviceId)) {
            return;
        }
        Collection leases = this._registryRepository.getLeases(serviceId);
        if (CollectionExtension.isEmpty((Collection)leases)) {
            return;
        }
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (Lease lease : leases) {
            Instance instance = ((Instance)lease.data()).clone();
            instances.add(instance);
            boolean isDown = this.isInstanceDown(instance);
            instance.setStatus(isDown ? "down" : "up");
            HashMap<String, String> instanceMetadata = instance.getMetadata();
            if (instanceMetadata == null) {
                instanceMetadata = new HashMap<String, String>();
                instance.setMetadata(instanceMetadata);
            }
            instanceMetadata.put("creationTime", String.valueOf(lease.creationTime()));
            instanceMetadata.put("renewalTime", String.valueOf(lease.renewalTime()));
            instanceMetadata.put("ttl", String.valueOf(lease.ttl()));
        }
        service.setInstances(instances);
    }

    public void waitForPeerSync() {
        ThreadExtension.sleep((int)((Integer)this._managementDBSyncWaitTimeProperty.getValue()));
    }

    private boolean refreshCache() {
        Map<String, List<ServerKey>> serverKeyChangeMap;
        Map<String, List<InstanceKey>> instanceKeyChangeMap;
        try {
            instanceKeyChangeMap = this.refreshInstanceOperationsCache();
        }
        catch (Throwable ex) {
            _logger.error("Instance operations cache refresh failed", ex);
            return false;
        }
        try {
            serverKeyChangeMap = this.refreshServerOperationsCache();
        }
        catch (Throwable ex) {
            _logger.error("Server operations cache refresh failed", ex);
            return false;
        }
        if (!ServiceNodeUtil.canServiceDiscovery((ServiceNodeStatus)NodeManager.INSTANCE.nodeStatus())) {
            return true;
        }
        Set<InstanceChange> instanceChanges = this.generateInstanceChanges(this._registryRepository.getInstances(), instanceKeyChangeMap, serverKeyChangeMap);
        Set<InstanceChange> logicalInstanceChanges = this.generateInstanceChanges(this.groupRepository.getLogicalInstances(), instanceKeyChangeMap, serverKeyChangeMap);
        HashMap reloadServices = Maps.newHashMap();
        for (InstanceChange instanceChange : logicalInstanceChanges) {
            String serviceId;
            if (instanceChange.getInstance() == null || StringExtension.isBlank((String)instanceChange.getInstance().getServiceId()) || reloadServices.containsKey(serviceId = instanceChange.getInstance().getServiceId())) continue;
            reloadServices.put(serviceId, InstanceChanges.newReloadInstanceChange((String)serviceId));
        }
        for (InstanceChange instanceChange : instanceChanges) {
            if (instanceChange.getInstance() == null || StringExtension.isBlank((String)instanceChange.getInstance().getServiceId()) || reloadServices.containsKey(instanceChange.getInstance().getServiceId())) continue;
            this._registryRepository.addInstanceChange(instanceChange);
        }
        for (InstanceChange instanceChange : reloadServices.values()) {
            this._registryRepository.addInstanceChange(instanceChange);
        }
        return true;
    }

    private Map<String, List<InstanceKey>> refreshInstanceOperationsCache() {
        HashMap<InstanceKey, InstanceOperations> allInstanceOperationsMap = new HashMap<InstanceKey, InstanceOperations>();
        List<InstanceModel> instances = this._instanceDao.queryInstances();
        if (instances == null) {
            instances = new ArrayList<InstanceModel>();
        }
        for (InstanceModel instance : instances) {
            if (instance == null || StringExtension.isBlank((String)instance.getOperation())) continue;
            InstanceKey instanceKey = ManagementRepository.toInstanceKey(instance);
            InstanceOperations instanceOperations = allInstanceOperationsMap.get(instanceKey);
            if (instanceOperations == null) {
                instanceOperations = new InstanceOperations(instanceKey, new ArrayList<String>());
                allInstanceOperationsMap.put(instanceKey, instanceOperations);
            }
            HashSet<String> uniqueOperations = new HashSet<String>(instanceOperations.getOperations());
            uniqueOperations.add(instance.getOperation());
            instanceOperations.setOperations(new ArrayList<String>(uniqueOperations));
        }
        Set<InstanceKey> oldKeys = this._allInstanceOperationsMap.keySet();
        this._allInstanceOperationsMap = allInstanceOperationsMap;
        return this.generateKeyChange(oldKeys, this._allInstanceOperationsMap.keySet());
    }

    private Map<String, List<ServerKey>> refreshServerOperationsCache() {
        HashMap<ServerKey, ServerOperations> allServerOperationsMap = new HashMap<ServerKey, ServerOperations>();
        List<ServerModel> servers = this._serverDao.queryServers();
        if (servers == null) {
            servers = new ArrayList<ServerModel>();
        }
        for (ServerModel server : servers) {
            if (server == null || StringExtension.isBlank((String)server.getOperation())) continue;
            ServerKey serverKey = ManagementRepository.toServerKey(server);
            ServerOperations serverOperations = allServerOperationsMap.get(serverKey);
            if (serverOperations == null) {
                serverOperations = new ServerOperations(serverKey, new ArrayList<String>());
                allServerOperationsMap.put(serverKey, serverOperations);
            }
            HashSet<String> uniqueOperations = new HashSet<String>(serverOperations.getOperations());
            uniqueOperations.add(server.getOperation());
            serverOperations.setOperations(new ArrayList<String>(uniqueOperations));
        }
        Set<ServerKey> oldKeys = this._allServerOperationsMap.keySet();
        this._allServerOperationsMap = allServerOperationsMap;
        return this.generateKeyChange(oldKeys, this._allServerOperationsMap.keySet());
    }

    private <T> Map<String, List<T>> generateKeyChange(Set<T> oldKeys, Set<T> newKeys) {
        HashMap<String, List<T>> keyChangeMap = new HashMap<String, List<T>>();
        ArrayList<T> removed = new ArrayList<T>();
        keyChangeMap.put("delete", removed);
        for (T serverKey : oldKeys) {
            if (newKeys.contains(serverKey)) continue;
            removed.add(serverKey);
        }
        ArrayList<T> added = new ArrayList<T>();
        keyChangeMap.put("new", added);
        for (T serverKey : newKeys) {
            if (oldKeys.contains(serverKey)) continue;
            added.add(serverKey);
        }
        return keyChangeMap;
    }

    private Set<InstanceChange> generateInstanceChanges(Map<InstanceKey, Instance> instancesMap, Map<String, List<InstanceKey>> instanceKeyChangeMap, Map<String, List<ServerKey>> serverKeyChangeMap) {
        Instance instance;
        List serverInstances;
        HashSet<InstanceChange> changes = new HashSet<InstanceChange>();
        if (CollectionExtension.isEmpty(instancesMap)) {
            return changes;
        }
        ArrayListMultimap serverInstancesMap = ArrayListMultimap.create();
        for (Instance instance2 : instancesMap.values()) {
            serverInstancesMap.put((Object)instance2.getIp(), (Object)instance2);
        }
        for (ServerKey serverKey : serverKeyChangeMap.get("delete")) {
            serverInstances = serverInstancesMap.get((Object)serverKey.getServerId());
            if (serverInstances == null) continue;
            for (Instance instance3 : serverInstances) {
                changes.add(new InstanceChange(instance3, "new"));
            }
        }
        for (InstanceKey instanceKey : instanceKeyChangeMap.get("delete")) {
            instance = instancesMap.get(instanceKey);
            if (instance == null) continue;
            changes.add(new InstanceChange(instance, "new"));
        }
        for (ServerKey serverKey : serverKeyChangeMap.get("new")) {
            serverInstances = serverInstancesMap.get((Object)serverKey.getServerId());
            if (serverInstances == null) continue;
            for (Instance instance3 : serverInstances) {
                changes.add(new InstanceChange(instance3, "delete"));
            }
        }
        for (InstanceKey instanceKey : instanceKeyChangeMap.get("new")) {
            instance = instancesMap.get(instanceKey);
            if (instance == null) continue;
            changes.add(new InstanceChange(instance, "delete"));
        }
        return changes;
    }

    private void filterService(Service service, DiscoveryConfig discoveryConfig) {
        if (service == null) {
            return;
        }
        for (DiscoveryFilter filter : this.filters) {
            try {
                filter.filter(service, discoveryConfig);
            }
            catch (Throwable ex) {
                _logger.error("Failed to execute filter " + filter, ex);
            }
        }
    }

    private static interface KeyChange {
        public static final String NEW = "new";
        public static final String DELETE = "delete";
    }
}

