/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import java.util.List;
import org.mydotey.artemis.HasResponseStatus;
import org.mydotey.artemis.management.GetServiceRequest;
import org.mydotey.artemis.management.GetServiceResponse;
import org.mydotey.artemis.management.GetServicesRequest;
import org.mydotey.artemis.management.GetServicesResponse;
import org.mydotey.artemis.management.GroupRepository;
import org.mydotey.artemis.management.ManagementRepository;
import org.mydotey.artemis.management.ManagementService;
import org.mydotey.artemis.management.dao.InstanceModel;
import org.mydotey.artemis.management.dao.ServerModel;
import org.mydotey.artemis.management.instance.GetAllInstanceOperationsRequest;
import org.mydotey.artemis.management.instance.GetAllInstanceOperationsResponse;
import org.mydotey.artemis.management.instance.GetInstanceOperationsRequest;
import org.mydotey.artemis.management.instance.GetInstanceOperationsResponse;
import org.mydotey.artemis.management.instance.InstanceOperations;
import org.mydotey.artemis.management.instance.IsInstanceDownRequest;
import org.mydotey.artemis.management.instance.IsInstanceDownResponse;
import org.mydotey.artemis.management.instance.OperateInstanceRequest;
import org.mydotey.artemis.management.instance.OperateInstanceResponse;
import org.mydotey.artemis.management.server.GetAllServerOperationsRequest;
import org.mydotey.artemis.management.server.GetAllServerOperationsResponse;
import org.mydotey.artemis.management.server.GetServerOperationsRequest;
import org.mydotey.artemis.management.server.GetServerOperationsResponse;
import org.mydotey.artemis.management.server.IsServerDownRequest;
import org.mydotey.artemis.management.server.IsServerDownResponse;
import org.mydotey.artemis.management.server.OperateServerRequest;
import org.mydotey.artemis.management.server.OperateServerResponse;
import org.mydotey.artemis.management.server.ServerOperations;
import org.mydotey.artemis.management.util.CheckResult;
import org.mydotey.artemis.management.util.ModelUtil;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.mydotey.artemis.util.ServiceNodeUtil;
import org.mydotey.artemis.util.StringUtil;
import org.mydotey.java.StringExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementServiceImpl
implements ManagementService {
    private static final Logger logger = LoggerFactory.getLogger(ManagementServiceImpl.class);
    private static ManagementServiceImpl instance;
    private final ManagementRepository managementRepository = ManagementRepository.getInstance();
    private final GroupRepository groupRepository = GroupRepository.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ManagementServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<ManagementServiceImpl> clazz = ManagementServiceImpl.class;
        synchronized (ManagementServiceImpl.class) {
            if (instance != null) return instance;
            instance = new ManagementServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ManagementServiceImpl() {
    }

    @Override
    public OperateInstanceResponse operateInstance(OperateInstanceRequest request) {
        return (OperateInstanceResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.operate-instance", () -> this.operateInstanceImpl(request));
    }

    @Override
    public OperateServerResponse operateServer(OperateServerRequest request) {
        return (OperateServerResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.operate-server", () -> this.operateServerImpl(request));
    }

    @Override
    public GetInstanceOperationsResponse getInstanceOperations(GetInstanceOperationsRequest request) {
        return (GetInstanceOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.instance-operations", () -> this.getInstanceOperationsImpl(request));
    }

    @Override
    public GetServerOperationsResponse getServerOperations(GetServerOperationsRequest request) {
        return (GetServerOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.server-operations", () -> this.getServerOperationsImpl(request));
    }

    @Override
    public GetAllInstanceOperationsResponse getAllInstanceOperations(GetAllInstanceOperationsRequest request) {
        return (GetAllInstanceOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.all-instance-operations", () -> this.getAllInstanceOperationsImpl(request));
    }

    @Override
    public GetAllServerOperationsResponse getAllServerOperations(GetAllServerOperationsRequest request) {
        return (GetAllServerOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.all-server-operations", () -> this.getAllServerOperationsImpl(request));
    }

    @Override
    public IsInstanceDownResponse isInstanceDown(IsInstanceDownRequest request) {
        return (IsInstanceDownResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.instance-down", () -> this.isInstanceDownImpl(request));
    }

    @Override
    public IsServerDownResponse isServerDown(IsServerDownRequest request) {
        return (IsServerDownResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.server-down", () -> this.isServerDownImpl(request));
    }

    @Override
    public GetServicesResponse getServices(GetServicesRequest request) {
        return (GetServicesResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.services", () -> this.getServicesImpl(request));
    }

    @Override
    public GetServiceResponse getService(GetServiceRequest request) {
        return (GetServiceResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.service", () -> this.getServiceImpl(request));
    }

    private OperateInstanceResponse operateInstanceImpl(OperateInstanceRequest request) {
        OperateInstanceResponse response = new OperateInstanceResponse();
        if (!ServiceNodeUtil.checkCurrentNode((HasResponseStatus)response)) {
            return response;
        }
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return response;
        }
        InstanceModel instance = ModelUtil.newInstance(request.getInstanceKey(), request.getOperation(), request.getOperatorId(), request.getToken());
        CheckResult checkResult = ModelUtil.check(instance);
        if (!checkResult.isValid()) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)checkResult.errorMessage(), (String)"bad-request"));
            return response;
        }
        try {
            if (request.isOperationComplete()) {
                this.managementRepository.deleteInstance(instance);
            } else {
                this.managementRepository.insertInstance(instance);
            }
            this.managementRepository.waitForPeerSync();
            response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
            return response;
        }
        catch (Throwable ex) {
            String errorMessage = "Update instance failed.";
            logger.error(errorMessage, ex);
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)errorMessage, (String)"internal-service-error"));
            return response;
        }
    }

    private OperateServerResponse operateServerImpl(OperateServerRequest request) {
        OperateServerResponse response = new OperateServerResponse();
        if (!ServiceNodeUtil.checkCurrentNode((HasResponseStatus)response)) {
            return response;
        }
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return response;
        }
        ServerModel server = ModelUtil.newServer(request.getServerKey(), request.getOperation(), request.getOperatorId(), request.getToken());
        CheckResult checkResult = ModelUtil.check(server);
        if (!checkResult.isValid()) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)checkResult.errorMessage(), (String)"bad-request"));
            return response;
        }
        try {
            if (request.isOperationComplete()) {
                this.managementRepository.deleteServer(server);
            } else {
                this.managementRepository.insertServer(server);
            }
            this.managementRepository.waitForPeerSync();
            response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
            return response;
        }
        catch (Throwable ex) {
            String errorMessage = "Update server failed.";
            logger.error(errorMessage, ex);
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)errorMessage, (String)"internal-service-error"));
            return response;
        }
    }

    private GetInstanceOperationsResponse getInstanceOperationsImpl(GetInstanceOperationsRequest request) {
        GetInstanceOperationsResponse response = new GetInstanceOperationsResponse();
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return response;
        }
        if (request.getInstanceKey() == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request.instanceKey is null", (String)"bad-request"));
            return response;
        }
        InstanceOperations instanceOperations = this.managementRepository.getInstanceOperations(request.getInstanceKey());
        response.setOperations(instanceOperations);
        response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
        return response;
    }

    public GetServerOperationsResponse getServerOperationsImpl(GetServerOperationsRequest request) {
        GetServerOperationsResponse response = new GetServerOperationsResponse();
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return response;
        }
        if (request.getServerKey() == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request.serverKey is null", (String)"bad-request"));
            return response;
        }
        ServerOperations serverOperations = this.managementRepository.getServerOperations(request.getServerKey());
        response.setOperations(serverOperations);
        response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
        return response;
    }

    private GetAllInstanceOperationsResponse getAllInstanceOperationsImpl(GetAllInstanceOperationsRequest request) {
        GetAllInstanceOperationsResponse response = new GetAllInstanceOperationsResponse();
        String regionId = request == null ? null : request.getRegionId();
        List<InstanceOperations> allInstanceOperations = this.managementRepository.getAllInstanceOperations(regionId);
        response.setAllInstanceOperations(allInstanceOperations);
        response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
        return response;
    }

    private GetAllServerOperationsResponse getAllServerOperationsImpl(GetAllServerOperationsRequest request) {
        GetAllServerOperationsResponse response = new GetAllServerOperationsResponse();
        String regionId = request == null ? null : request.getRegionId();
        List<ServerOperations> allServerOperations = this.managementRepository.getAllServerOperations(regionId);
        response.setAllServerOperations(allServerOperations);
        response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
        return response;
    }

    private IsInstanceDownResponse isInstanceDownImpl(IsInstanceDownRequest request) {
        IsInstanceDownResponse response = new IsInstanceDownResponse();
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return response;
        }
        if (request.getInstance() == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request.instance is null", (String)"bad-request"));
            return response;
        }
        response.setDown(this.managementRepository.isInstanceDown(request.getInstance()));
        response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
        return response;
    }

    private IsServerDownResponse isServerDownImpl(IsServerDownRequest request) {
        IsServerDownResponse response = new IsServerDownResponse();
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return response;
        }
        if (request.getServerKey() == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request.serverKey null", (String)"bad-request"));
            return response;
        }
        response.setDown(this.managementRepository.isServerDown(request.getServerKey()));
        response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
        return response;
    }

    private GetServicesResponse getServicesImpl(GetServicesRequest request) {
        GetServicesResponse response = new GetServicesResponse(this.managementRepository.getAllServices(), System.currentTimeMillis(), ResponseStatusUtil.SUCCESS_STATUS);
        return response;
    }

    private GetServiceResponse getServiceImpl(GetServiceRequest request) {
        GetServiceResponse response = new GetServiceResponse();
        try {
            if (request == null || StringExtension.isBlank((String)request.getServiceId())) {
                return new GetServiceResponse(null, ResponseStatusUtil.newFailStatus((String)"Request is null or request.servcieId is null.", (String)"bad-request"));
            }
            String serviceId = request.getServiceId();
            response.setService(this.managementRepository.getService(serviceId));
            response.setGroups(this.groupRepository.getServiceInstanceGroups(serviceId));
            response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
        }
        catch (Throwable ex) {
            logger.error("GetService failed. Request: " + StringUtil.toJson((Object)request), ex);
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)ex.getMessage(), (String)"internal-service-error"));
        }
        return response;
    }
}

