/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mydotey.artemis.config.ArtemisConfig;
import org.mydotey.artemis.management.common.OperationContext;
import org.mydotey.artemis.management.zone.ZoneKey;
import org.mydotey.artemis.management.zone.ZoneOperations;
import org.mydotey.artemis.management.zone.dao.ZoneOperationDao;
import org.mydotey.artemis.management.zone.dao.ZoneOperationLogDao;
import org.mydotey.artemis.management.zone.model.ZoneOperationModel;
import org.mydotey.artemis.management.zone.util.ZoneOperationsUtil;
import org.mydotey.artemis.registry.RegistryRepository;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.InstanceChanges;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.java.collection.CollectionExtension;
import org.mydotey.scf.filter.RangeValueConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneRepository {
    private static final Logger logger = LoggerFactory.getLogger(ZoneRepository.class);
    private static volatile ZoneRepository instance;
    private volatile long lastRefreshTime;
    private volatile boolean lastRefreshSuccess;
    private volatile Map<ZoneKey, ZoneOperations> zoneOperations = Maps.newHashMap();
    private volatile ListMultimap<String, ZoneOperations> serviceZoneOperations = ArrayListMultimap.create();
    private DynamicScheduledThread cacheRefresher;
    private final ZoneOperationDao zoneOperationDao = ZoneOperationDao.INSTANCE;
    private final ZoneOperationLogDao zoneOperationLogDao = ZoneOperationLogDao.INSTANCE;
    private final RegistryRepository registryRepository = RegistryRepository.getInstance();
    private AtomicBoolean _inited = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZoneRepository getInstance() {
        if (instance != null) return instance;
        Class<ZoneRepository> clazz = ZoneRepository.class;
        synchronized (ZoneRepository.class) {
            if (instance != null) return instance;
            instance = new ZoneRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ZoneRepository() {
    }

    public void init() {
        if (!this._inited.compareAndSet(false, true)) {
            return;
        }
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(ArtemisConfig.properties(), new RangeValueConfig((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10000)), new RangeValueConfig((Comparable)Integer.valueOf(5000), (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(60000)));
        String cacheRefreshKey = "artemis.management.zone.data.cache-refresher";
        this.cacheRefresher = new DynamicScheduledThread("artemis.management.zone.data.cache-refresher", () -> {
            this.lastRefreshTime = System.currentTimeMillis();
            this.lastRefreshSuccess = (Boolean)ArtemisTraceExecutor.INSTANCE.execute("artemis.management.zone.data.cache-refresher", () -> this.refreshCache());
        }, dynamicScheduledThreadConfig);
        this.cacheRefresher.setDaemon(true);
        this.cacheRefresher.start();
    }

    public boolean isZoneDown(ZoneKey zoneKey) {
        return this.getZoneOperations(zoneKey) != null;
    }

    public List<ZoneOperations> getAllZoneOperations(String regionId) {
        return Lists.newArrayList(this.zoneOperations.values());
    }

    public ZoneOperations getZoneOperations(ZoneKey zoneKey) {
        return this.zoneOperations.get(zoneKey);
    }

    public List<ZoneOperations> getServiceZoneOperations(String serviceId) {
        return this.serviceZoneOperations.get((Object)serviceId);
    }

    public List<ZoneOperations> getZoneOperationsList(ZoneOperationModel filter) {
        return Lists.newArrayList(this.generateZoneOperations(this.zoneOperationDao.select(filter)).values());
    }

    public void operateGroupOperations(OperationContext operationContext, List<ZoneOperationModel> zoneOperations, boolean isOperationComplete) {
        if (isOperationComplete) {
            this.zoneOperationDao.delete(zoneOperations);
            this.zoneOperationLogDao.insert(ZoneOperationsUtil.newZoneOperationLogModels(operationContext, zoneOperations, isOperationComplete));
        } else {
            this.zoneOperationDao.insertOrUpdate(zoneOperations);
            this.zoneOperationLogDao.insert(ZoneOperationsUtil.newZoneOperationLogModels(operationContext, zoneOperations, isOperationComplete));
        }
    }

    public boolean isLastRefreshSuccess() {
        return this.lastRefreshSuccess;
    }

    public long getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    protected boolean refreshCache() {
        Set<String> changedServices;
        try {
            changedServices = this.refreshZoneOperations();
        }
        catch (Throwable ex) {
            logger.error("zone operation cache refresh failed", ex);
            return false;
        }
        for (String serviceKey : changedServices) {
            this.registryRepository.addInstanceChange(InstanceChanges.newReloadInstanceChange((String)serviceKey));
        }
        return true;
    }

    private Set<String> refreshZoneOperations() {
        Map<ZoneKey, ZoneOperations> newZoneOperations = this.generateZoneOperations(this.zoneOperationDao.query());
        ArrayListMultimap newServiceZoneOperations = ArrayListMultimap.create();
        for (ZoneOperations z : newZoneOperations.values()) {
            newServiceZoneOperations.put((Object)z.getZoneKey().getServiceId(), (Object)z);
        }
        Set oldServiceKeys = this.serviceZoneOperations.keySet();
        this.zoneOperations = newZoneOperations;
        this.serviceZoneOperations = newServiceZoneOperations;
        Set newServiceKeys = this.serviceZoneOperations.keySet();
        HashSet diffs = Sets.newHashSet((Iterable)Sets.difference((Set)oldServiceKeys, (Set)newServiceKeys));
        diffs.addAll(Sets.difference((Set)newServiceKeys, (Set)oldServiceKeys));
        return diffs;
    }

    private Map<ZoneKey, ZoneOperations> generateZoneOperations(List<ZoneOperationModel> models) {
        HashMap zoneOperations = Maps.newHashMap();
        if (CollectionExtension.isEmpty(models)) {
            return zoneOperations;
        }
        ArrayListMultimap operations = ArrayListMultimap.create();
        for (ZoneOperationModel model : models) {
            ZoneKey zoneKey = new ZoneKey(model.getRegionId(), model.getServiceId(), model.getZoneId());
            operations.put((Object)zoneKey, (Object)model.getOperation());
        }
        for (ZoneKey zoneKey : operations.keySet()) {
            ZoneOperations z = new ZoneOperations(zoneKey, operations.get((Object)zoneKey));
            zoneOperations.put(zoneKey, z);
        }
        return zoneOperations;
    }

    protected void stopRefresh() {
        this.cacheRefresher.shutdown();
    }
}

