/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management;

import org.mydotey.artemis.HasResponseStatus;
import org.mydotey.artemis.management.ZoneRepository;
import org.mydotey.artemis.management.zone.GetAllZoneOperationsRequest;
import org.mydotey.artemis.management.zone.GetAllZoneOperationsResponse;
import org.mydotey.artemis.management.zone.GetZoneOperationsListRequest;
import org.mydotey.artemis.management.zone.GetZoneOperationsListResponse;
import org.mydotey.artemis.management.zone.GetZoneOperationsRequest;
import org.mydotey.artemis.management.zone.GetZoneOperationsResponse;
import org.mydotey.artemis.management.zone.IsZoneDownRequest;
import org.mydotey.artemis.management.zone.IsZoneDownResponse;
import org.mydotey.artemis.management.zone.OperateZoneOperationsRequest;
import org.mydotey.artemis.management.zone.OperateZoneOperationsResponse;
import org.mydotey.artemis.management.zone.ZoneService;
import org.mydotey.artemis.management.zone.model.ZoneOperationModel;
import org.mydotey.artemis.management.zone.util.ZoneOperationsUtil;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.mydotey.artemis.util.ServiceNodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneServiceImpl
implements ZoneService {
    private static volatile ZoneServiceImpl instance;
    private static final Logger logger;
    private final ZoneRepository zoneRepository = ZoneRepository.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZoneServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<ZoneServiceImpl> clazz = ZoneServiceImpl.class;
        synchronized (ZoneServiceImpl.class) {
            if (instance != null) return instance;
            instance = new ZoneServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ZoneServiceImpl() {
    }

    @Override
    public GetAllZoneOperationsResponse getAllZoneOperations(GetAllZoneOperationsRequest request) {
        return (GetAllZoneOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.all-zone-operations", () -> {
            GetAllZoneOperationsResponse response = new GetAllZoneOperationsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setAllZoneOperations(this.zoneRepository.getAllZoneOperations(request.getRegionId()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                String errorMessage = "get all-zone-operations failed.";
                logger.error(errorMessage, ex);
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)(errorMessage + ex.getMessage()), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetZoneOperationsResponse getZoneOperations(GetZoneOperationsRequest request) {
        return (GetZoneOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.zone-operations", () -> {
            GetZoneOperationsResponse response = new GetZoneOperationsResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setOperations(this.zoneRepository.getZoneOperations(request.getZoneKey()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                String errorMessage = "get zone-operations failed.";
                logger.error(errorMessage, ex);
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)(errorMessage + ex.getMessage()), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public GetZoneOperationsListResponse getZoneOperationsList(GetZoneOperationsListRequest request) {
        return (GetZoneOperationsListResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.zone-operations-list", () -> {
            GetZoneOperationsListResponse response = new GetZoneOperationsListResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setZoneOperationsList(this.zoneRepository.getZoneOperationsList(new ZoneOperationModel(request.getRegionId(), request.getServiceId(), request.getZoneId())));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                String errorMessage = "get zone-operations-list failed.";
                logger.error(errorMessage, ex);
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)(errorMessage + ex.getMessage()), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public IsZoneDownResponse isZoneDown(IsZoneDownRequest request) {
        return (IsZoneDownResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.get.is-zone-down", () -> {
            IsZoneDownResponse response = new IsZoneDownResponse();
            if (!this.check(request, response)) {
                return response;
            }
            try {
                response.setDown(this.zoneRepository.getZoneOperations(request.getZoneKey()) != null);
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                String errorMessage = "is-zone-down failed.";
                logger.error(errorMessage, ex);
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)(errorMessage + ex.getMessage()), (String)"internal-service-error"));
                return response;
            }
        });
    }

    @Override
    public OperateZoneOperationsResponse operateZoneOperations(OperateZoneOperationsRequest request) {
        return (OperateZoneOperationsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.management.operate.zone-operations", () -> {
            OperateZoneOperationsResponse response = new OperateZoneOperationsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                this.zoneRepository.operateGroupOperations(request, ZoneOperationsUtil.newZoneOperationModels(request.getZoneOperationsList()), request.isOperationComplete());
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                return response;
            }
            catch (Throwable ex) {
                String errorMessage = "operate zone-operations failed.";
                logger.error(errorMessage, ex);
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)(errorMessage + ex.getMessage()), (String)"internal-service-error"));
                return response;
            }
        });
    }

    private boolean check(Object request, HasResponseStatus response) {
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return false;
        }
        return true;
    }

    private boolean updateCheck(Object request, HasResponseStatus response) {
        return ServiceNodeUtil.checkCurrentNode((HasResponseStatus)response) && this.check(request, response);
    }

    static {
        logger = LoggerFactory.getLogger(ZoneServiceImpl.class);
    }
}

