/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.canary;

import com.google.common.collect.Sets;
import org.mydotey.artemis.HasResponseStatus;
import org.mydotey.artemis.management.GroupRepository;
import org.mydotey.artemis.management.canary.CanaryService;
import org.mydotey.artemis.management.canary.CanaryServices;
import org.mydotey.artemis.management.canary.UpdateCanaryIPsRequest;
import org.mydotey.artemis.management.canary.UpdateCanaryIPsResponse;
import org.mydotey.artemis.management.group.model.GroupModel;
import org.mydotey.artemis.management.group.model.RouteRuleGroupModel;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.mydotey.artemis.util.ServiceNodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanaryServiceImpl
implements CanaryService {
    private static final Logger logger = LoggerFactory.getLogger(CanaryServiceImpl.class);
    private static CanaryServiceImpl instance;
    private final GroupRepository groupRepository = GroupRepository.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CanaryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<CanaryServiceImpl> clazz = CanaryServiceImpl.class;
        synchronized (CanaryServiceImpl.class) {
            if (instance != null) return instance;
            instance = new CanaryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public UpdateCanaryIPsResponse updateCanaryIPs(UpdateCanaryIPsRequest request) {
        return (UpdateCanaryIPsResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.service.canary.update.canary-ips", () -> {
            UpdateCanaryIPsResponse response = new UpdateCanaryIPsResponse();
            if (!this.updateCheck(request, response)) {
                return response;
            }
            try {
                GroupModel group = CanaryServices.generateCanaryGroup(request.getServiceId(), request.getAppId());
                Long routeRuleId = this.groupRepository.generateRouteRule(CanaryServices.generateCanaryRouteRule(request.getServiceId())).getRouteRuleId();
                Long groupId = this.groupRepository.generateGroup(group).getGroupId();
                this.groupRepository.generateRouteRuleGroup(new RouteRuleGroupModel(null, routeRuleId, groupId, 5));
                this.groupRepository.updateGroupInstances(request, groupId, Sets.newHashSet(request.getCanaryIps()));
                response.setResponseStatus(ResponseStatusUtil.SUCCESS_STATUS);
                this.groupRepository.waitForPeerSync();
                return response;
            }
            catch (Throwable ex) {
                String errorMessage = "update canary ips";
                logger.error(errorMessage, ex);
                response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)errorMessage, (String)"internal-service-error"));
                return response;
            }
        });
    }

    private boolean check(Object request, HasResponseStatus response) {
        if (request == null) {
            response.setResponseStatus(ResponseStatusUtil.newFailStatus((String)"request is null", (String)"bad-request"));
            return false;
        }
        return true;
    }

    private boolean updateCheck(Object request, HasResponseStatus response) {
        return ServiceNodeUtil.checkCurrentNode((HasResponseStatus)response) && this.check(request, response);
    }
}

