/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.dao;

import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class DataConfig {
    private static final String DB_CONFIG_FILE = "data-source.properties";
    private static DataSource _dataSource;
    private static DataSourceTransactionManager _dataSourceTransactionManager;
    private static JdbcTemplate _jdbcTemplate;
    private static AtomicBoolean _inited;

    public static void init() throws Exception {
        if (!_inited.compareAndSet(false, true)) {
            return;
        }
        DataConfig.initDataSource();
        _dataSourceTransactionManager = new DataSourceTransactionManager(_dataSource);
        _jdbcTemplate = new JdbcTemplate(_dataSource);
    }

    private static void initDataSource() throws Exception {
        Properties prop = new Properties();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(DB_CONFIG_FILE);){
            if (is == null) {
                throw new RuntimeException("No data-source.properties in class path.");
            }
            prop.load(is);
        }
        _dataSource = BasicDataSourceFactory.createDataSource((Properties)prop);
    }

    public static JdbcTemplate jdbcTemplate() {
        return _jdbcTemplate;
    }

    public static DataSourceTransactionManager dataSourceTransactionManager() {
        return _dataSourceTransactionManager;
    }

    public DataSource dataSource() {
        return _dataSource;
    }

    static {
        _inited = new AtomicBoolean();
    }
}

