/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.mydotey.artemis.ServerKey;
import org.mydotey.artemis.management.dao.DataConfig;
import org.mydotey.artemis.management.dao.InstanceModel;
import org.mydotey.java.StringExtension;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class InstanceDao {
    public static final InstanceDao INSTANCE = new InstanceDao();
    private final String queryInstanceSql = "select distinct region_id, service_id, instance_id, operation from instance where region_id=? and service_id=? and instance_id=?";
    private final String queryInstancesSql = "select distinct region_id, service_id, instance_id, operation from instance where region_id=?";
    private final String queryInstancesSql2 = "select distinct region_id, service_id, instance_id, operation from instance";
    private final RowMapper<InstanceModel> queryInstancesRowMapper = new RowMapper<InstanceModel>(){

        public InstanceModel mapRow(ResultSet rs, int arg1) throws SQLException {
            InstanceModel instance = new InstanceModel();
            instance.setRegionId(rs.getString(1));
            instance.setServiceId(rs.getString(2));
            instance.setInstanceId(rs.getString(3));
            instance.setOperation(rs.getString(4));
            return instance;
        }
    };

    private InstanceDao() {
    }

    public List<InstanceModel> queryInstance(final String regionId, final String serviceId, final String instanceId) {
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps = conn.prepareStatement("select distinct region_id, service_id, instance_id, operation from instance where region_id=? and service_id=? and instance_id=?");
                ps.setString(1, regionId);
                ps.setString(2, serviceId);
                ps.setString(3, instanceId);
                return ps;
            }
        }, this.queryInstancesRowMapper);
    }

    public List<InstanceModel> queryInstances(final String regionId) {
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps = conn.prepareStatement("select distinct region_id, service_id, instance_id, operation from instance where region_id=?");
                ps.setString(1, regionId);
                return ps;
            }
        }, this.queryInstancesRowMapper);
    }

    public List<InstanceModel> queryInstances() {
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                return conn.prepareStatement("select distinct region_id, service_id, instance_id, operation from instance");
            }
        }, this.queryInstancesRowMapper);
    }

    public List<InstanceModel> queryInstances(final String regionId, final List<String> serviceIds) {
        if (CollectionUtils.isEmpty(serviceIds)) {
            return Lists.newArrayList();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < serviceIds.size(); ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        final String sql = "select distinct region_id, service_id, instance_id, operation from instance where region_id=? and service_id in (" + builder + ")";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps = conn.prepareStatement(sql);
                ps.setString(1, regionId);
                int len = serviceIds.size();
                for (int i = 0; i < len; ++i) {
                    ps.setString(i + 2, (String)serviceIds.get(i));
                }
                return ps;
            }
        }, this.queryInstancesRowMapper);
    }

    public List<InstanceModel> query(final String condition, final String ... args) {
        String sql = "select id, region_id, service_id, instance_id, operation, operator_id, token, create_time, datachange_lasttime from instance";
        return DataConfig.jdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps;
                if (StringExtension.isBlank((String)condition)) {
                    ps = conn.prepareStatement("select id, region_id, service_id, instance_id, operation, operator_id, token, create_time, datachange_lasttime from instance");
                } else {
                    ps = conn.prepareStatement(Joiner.on((String)" ").join((Object)"select id, region_id, service_id, instance_id, operation, operator_id, token, create_time, datachange_lasttime from instance", (Object)"where", new Object[]{condition}));
                    for (int i = 0; i < args.length; ++i) {
                        ps.setString(i + 1, args[i]);
                    }
                }
                return ps;
            }
        }, (RowMapper)new RowMapper<InstanceModel>(){

            public InstanceModel mapRow(ResultSet rs, int arg1) throws SQLException {
                InstanceModel instance = new InstanceModel();
                instance.setId(rs.getLong(1));
                instance.setRegionId(rs.getString(2));
                instance.setServiceId(rs.getString(3));
                instance.setInstanceId(rs.getString(4));
                instance.setOperation(rs.getString(5));
                instance.setOperatorId(rs.getString(6));
                instance.setToken(rs.getString(7));
                instance.setCreateTime(rs.getDate(8));
                instance.setUpdateTime(rs.getDate(9));
                return instance;
            }
        });
    }

    public void delete(final Long ... ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        DataConfig.jdbcTemplate().batchUpdate("delete from instance where id = ?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return ids.length;
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Long id = ids[i];
                if (id == null) {
                    ps.setLong(1, 0L);
                } else {
                    ps.setLong(1, id);
                }
            }
        });
    }

    public void delete(InstanceModel ... instances) {
        if (instances == null || instances.length == 0) {
            return;
        }
        this.delete(Lists.newArrayList((Object[])instances));
    }

    public void delete(final List<InstanceModel> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        DataConfig.jdbcTemplate().batchUpdate("delete from instance where region_id=? and service_id=? and instance_id=? and operation=?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return instances.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                InstanceModel instance = (InstanceModel)instances.get(index);
                ps.setString(1, instance.getRegionId());
                ps.setString(2, instance.getServiceId());
                ps.setString(3, instance.getInstanceId());
                ps.setString(4, instance.getOperation());
            }
        });
    }

    public void destroyServers(final List<ServerKey> serverKeys) {
        if (CollectionUtils.isEmpty(serverKeys)) {
            return;
        }
        DataConfig.jdbcTemplate().batchUpdate("delete from instance where region_id=? and instance_id=?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return serverKeys.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                ServerKey serverKey = (ServerKey)serverKeys.get(index);
                ps.setString(1, serverKey.getRegionId());
                ps.setString(2, serverKey.getServerId());
            }
        });
    }

    public void insert(InstanceModel ... instances) {
        if (instances == null || instances.length == 0) {
            return;
        }
        this.insert(Lists.newArrayList((Object[])instances));
    }

    public void insert(final List<InstanceModel> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        DataConfig.jdbcTemplate().batchUpdate("insert into instance (region_id, service_id, instance_id, operation, operator_id, token) values (?,?,?,?,?,?) on duplicate key update operator_id=?, token=?", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return instances.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                InstanceModel instance = (InstanceModel)instances.get(index);
                ps.setString(1, instance.getRegionId());
                ps.setString(2, instance.getServiceId());
                ps.setString(3, instance.getInstanceId());
                ps.setString(4, instance.getOperation());
                ps.setString(5, instance.getOperatorId());
                ps.setString(6, instance.getToken());
                ps.setString(7, instance.getOperatorId());
                ps.setString(8, instance.getToken());
            }
        });
    }
}

