/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.dao;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mydotey.artemis.management.dao.InstanceModel;
import org.springframework.util.CollectionUtils;

public class InstanceLogModel
extends InstanceModel {
    private boolean complete;
    private String extensions;

    public InstanceLogModel() {
    }

    public InstanceLogModel(String regionId, String serviceId, String instanceId, String operation, String operatorId) {
        super(regionId, serviceId, instanceId, operation, operatorId, null);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public static InstanceLogModel of(InstanceModel instance, boolean isComplete) {
        if (instance == null) {
            return null;
        }
        InstanceLogModel log = new InstanceLogModel();
        log.setRegionId(instance.getRegionId());
        log.setServiceId(instance.getServiceId());
        log.setInstanceId(instance.getInstanceId());
        log.setOperation(instance.getOperation());
        log.setOperatorId(instance.getOperatorId());
        log.setToken(instance.getToken());
        log.setComplete(isComplete);
        log.setExtensions("{}");
        return log;
    }

    public static List<InstanceLogModel> of(List<InstanceModel> instances, boolean isComplete) {
        if (CollectionUtils.isEmpty(instances)) {
            return Lists.newArrayList();
        }
        ArrayList logs = Lists.newArrayList();
        for (InstanceModel instance : instances) {
            logs.add(InstanceLogModel.of(instance, isComplete));
        }
        return logs;
    }
}

