/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.management.dao;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mydotey.artemis.management.dao.ServerModel;
import org.springframework.util.CollectionUtils;

public class ServerLogModel
extends ServerModel {
    private boolean complete;
    private String extensions;

    public ServerLogModel() {
    }

    public ServerLogModel(String regionId, String serverId, String operation, String operatorId) {
        super(regionId, serverId, operation, operatorId, null);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public static ServerLogModel of(ServerModel server, boolean isComplete) {
        if (server == null) {
            return null;
        }
        ServerLogModel log = new ServerLogModel();
        log.setRegionId(server.getRegionId());
        log.setServerId(server.getServerId());
        log.setOperation(server.getOperation());
        log.setOperatorId(server.getOperatorId());
        log.setToken(server.getToken());
        log.setComplete(isComplete);
        log.setExtensions("{}");
        return log;
    }

    public static List<ServerLogModel> of(List<ServerModel> servers, boolean isComplete) {
        if (CollectionUtils.isEmpty(servers)) {
            return Lists.newArrayList();
        }
        ArrayList logs = Lists.newArrayList();
        for (ServerModel server : servers) {
            logs.add(ServerLogModel.of(server, isComplete));
        }
        return logs;
    }
}

